/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.dao;

import com.viontech.keliu.model.CountData;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class CountDataKeyDao {
    @Resource
    private JdbcTemplate jdbcTemplate;
    private volatile BeanPropertyRowMapper<CountData> mapper = new BeanPropertyRowMapper(CountData.class);
    private final String SQL_GATE_DAY = "select DISTINCT gate_id as orgId,counttime as countTime from d_gate_day_count_data where countdate = ?;";
    private final String SQL_GATE_HOUR = "select DISTINCT gate_id as orgId,counttime as countTime from d_gate_hour_count_data where countdate = ?;";
    private final String SQL_GATE_MINUTE = "select DISTINCT gate_id as orgId,counttime as countTime from d_gate_minute_count_data where countdate = ?;";
    private final String SQL_ZONE_DAY = "select DISTINCT zone_id as orgId,counttime as countTime from d_zone_day_count_data where countdate = ?;";
    private final String SQL_ZONE_HOUR = "select DISTINCT zone_id as orgId,counttime as countTime from d_zone_hour_count_data where countdate =?;";
    private final String SQL_ZONE_MINUTE = "select DISTINCT zone_id as orgId,counttime as countTime from d_zone_minute_count_data where countdate = ?;";
    private final String SQL_FLOOR_DAY = "select DISTINCT floor_id as orgId,counttime as countTime from d_floor_day_count_data where countdate = ?;";
    private final String SQL_FLOOR_HOUR = "select DISTINCT floor_id as orgId,counttime as countTime from d_floor_hour_count_data where countdate = ?;";
    private final String SQL_FLOOR_MINUTE = "select DISTINCT floor_id as orgId,counttime as countTime from d_floor_minute_count_data where countdate = ?;";
    private final String SQL_MALL_DAY = "select DISTINCT mall_id as orgId,counttime as countTime from d_mall_day_count_data where countdate = ?;";
    private final String SQL_MALL_HOUR = "select DISTINCT mall_id as orgId,counttime as countTime from d_mall_hour_count_data where countdate = ?;";
    private final String SQL_MALL_MINUTE = "select DISTINCT mall_id as orgId,counttime as countTime from d_mall_minute_count_data where countdate = ?;";

    public List<CountData> getGateDay(Date countDate) {
        return this.getResult(countDate, "select DISTINCT gate_id as orgId,counttime as countTime from d_gate_day_count_data where countdate = ?;");
    }

    public List<CountData> getGateHour(Date countDate) {
        return this.getResult(countDate, "select DISTINCT gate_id as orgId,counttime as countTime from d_gate_hour_count_data where countdate = ?;");
    }

    public List<CountData> getGateMinute(Date countDate) {
        return this.getResult(countDate, "select DISTINCT gate_id as orgId,counttime as countTime from d_gate_minute_count_data where countdate = ?;");
    }

    public List<CountData> getZoneDay(Date countDate) {
        return this.getResult(countDate, "select DISTINCT zone_id as orgId,counttime as countTime from d_zone_day_count_data where countdate = ?;");
    }

    public List<CountData> getZoneHour(Date countDate) {
        return this.getResult(countDate, "select DISTINCT zone_id as orgId,counttime as countTime from d_zone_hour_count_data where countdate =?;");
    }

    public List<CountData> getZoneMinute(Date countDate) {
        return this.getResult(countDate, "select DISTINCT zone_id as orgId,counttime as countTime from d_zone_minute_count_data where countdate = ?;");
    }

    public List<CountData> getFloorDay(Date countDate) {
        return this.getResult(countDate, "select DISTINCT floor_id as orgId,counttime as countTime from d_floor_day_count_data where countdate = ?;");
    }

    public List<CountData> getFloorHour(Date countDate) {
        return this.getResult(countDate, "select DISTINCT floor_id as orgId,counttime as countTime from d_floor_hour_count_data where countdate = ?;");
    }

    public List<CountData> getFloorMinute(Date countDate) {
        return this.getResult(countDate, "select DISTINCT floor_id as orgId,counttime as countTime from d_floor_minute_count_data where countdate = ?;");
    }

    public List<CountData> getMallDay(Date countDate) {
        return this.getResult(countDate, "select DISTINCT mall_id as orgId,counttime as countTime from d_mall_day_count_data where countdate = ?;");
    }

    public List<CountData> getMallHour(Date countDate) {
        return this.getResult(countDate, "select DISTINCT mall_id as orgId,counttime as countTime from d_mall_hour_count_data where countdate = ?;");
    }

    public List<CountData> getMallMinute(Date countDate) {
        return this.getResult(countDate, "select DISTINCT mall_id as orgId,counttime as countTime from d_mall_minute_count_data where countdate = ?;");
    }

    private List<CountData> getResult(Date countDate, String sql) {
        return this.jdbcTemplate.query(sql, new Object[]{countDate}, (RowMapper)this.mapper);
    }
}

