/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class BatchJobDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final String SELECT_JOB_EXECUTION_BY_NAME = "SELECT *  FROM batch_job_execution AS bje LEFT JOIN batch_job_instance bji ON bje.job_instance_id=bji.job_instance_id WHERE bji.job_name=? ORDER BY job_execution_id DESC LIMIT 20 OFFSET ?";
    private static final String SELECT_JOB_STEP_EXECUTION_BY_JOB_EXECUTION_ID = "SELECT * FROM batch_step_execution WHERE job_execution_id = ? ORDER BY step_execution_id DESC";
    private static final String SELECT_ALL_JOB_EXECUTION = "SELECT * FROM batch_job_execution AS bje LEFT JOIN batch_job_instance bji ON bje.job_instance_id=bji.job_instance_id ORDER BY job_execution_id DESC LIMIT 20 OFFSET ?";
    private static final String COUNT_JOB_EXECUTION_BY_NAME = "SELECT count(1) FROM batch_job_execution WHERE job_instance_id IN (SELECT job_instance_id FROM batch_job_instance WHERE job_name=?)";
    private static final String COUNT_ALL_JOB_EXECUTION = "SELECT count(1) FROM batch_job_execution";

    public List<Map<String, Object>> getJobExecutionByName(String jobName, Integer page) {
        return this.jdbcTemplate.queryForList(SELECT_JOB_EXECUTION_BY_NAME, new Object[]{jobName, 20 * (page - 1)}, new int[]{12, 4});
    }

    public List<Map<String, Object>> getStepExecutionByJobExecutionId(Long jobId) {
        return this.jdbcTemplate.queryForList(SELECT_JOB_STEP_EXECUTION_BY_JOB_EXECUTION_ID, new Object[]{jobId}, new int[]{-5});
    }

    public Integer countJobExecutionByName(String name) {
        return (Integer)this.jdbcTemplate.queryForObject(COUNT_JOB_EXECUTION_BY_NAME, new Object[]{name}, Integer.class);
    }

    public List<Map<String, Object>> getAllJobExecution(Integer page) {
        return this.jdbcTemplate.queryForList(SELECT_ALL_JOB_EXECUTION, new Object[]{20 * (page - 1)}, new int[]{4});
    }

    public Integer countJobExecution() {
        return (Integer)this.jdbcTemplate.queryForObject(COUNT_ALL_JOB_EXECUTION, Integer.class);
    }

    public List<Map<String, Object>> getAllJobExecutionFilter(Integer page, ArrayList<String> codes, boolean all, String jobName) {
        String sql;
        Object[] args;
        int[] types;
        if (all) {
            ArrayList<String> list = new ArrayList<String>(codes.size());
            types = new int[codes.size() + 1];
            args = new Object[codes.size() + 1];
            for (int i = 0; i < codes.size(); ++i) {
                list.add("?");
                types[i] = 12;
                args[i] = codes.get(i);
            }
            args[codes.size()] = 20 * (page - 1);
            types[codes.size()] = 4;
            String ss = String.join((CharSequence)",", list);
            sql = "SELECT * FROM batch_job_execution AS bje LEFT JOIN batch_job_instance bji ON bje.job_instance_id=bji.job_instance_id where exit_code in (" + ss + ") ORDER BY job_execution_id DESC LIMIT 20 OFFSET ?";
        } else {
            ArrayList<String> list = new ArrayList<String>(codes.size());
            types = new int[codes.size() + 2];
            args = new Object[codes.size() + 2];
            for (int i = 0; i < codes.size(); ++i) {
                list.add("?");
                types[i] = 12;
                args[i] = codes.get(i);
            }
            args[codes.size()] = jobName;
            args[codes.size() + 1] = 20 * (page - 1);
            types[codes.size()] = 12;
            types[codes.size() + 1] = 4;
            String ss = String.join((CharSequence)",", list);
            sql = "SELECT *  FROM batch_job_execution AS bje LEFT JOIN batch_job_instance bji ON bje.job_instance_id=bji.job_instance_id WHERE exit_code IN (" + ss + ") AND bji.job_name=? ORDER BY job_execution_id DESC LIMIT 20 OFFSET ?";
        }
        return this.jdbcTemplate.queryForList(sql, args, types);
    }

    public Integer countJobExecutionFilter(ArrayList<String> codes, boolean all, String jobName) {
        String sql;
        Object[] args;
        int[] types;
        if (all) {
            ArrayList<String> list = new ArrayList<String>(codes.size());
            types = new int[codes.size()];
            args = new Object[codes.size()];
            for (int i = 0; i < codes.size(); ++i) {
                list.add("?");
                types[i] = 12;
                args[i] = codes.get(i);
            }
            String ss = String.join((CharSequence)",", list);
            sql = "SELECT count(1) FROM batch_job_execution AS bje LEFT JOIN batch_job_instance bji ON bje.job_instance_id=bji.job_instance_id where exit_code in (" + ss + ")";
        } else {
            ArrayList<String> list = new ArrayList<String>(codes.size());
            types = new int[codes.size() + 1];
            args = new Object[codes.size() + 1];
            args[0] = jobName;
            for (int i = 0; i < codes.size(); ++i) {
                list.add("?");
                types[i] = 12;
                args[i + 1] = codes.get(i);
            }
            types[codes.size()] = 12;
            String ss = String.join((CharSequence)",", list);
            sql = "SELECT count(1) FROM batch_job_execution WHERE job_instance_id IN (SELECT job_instance_id FROM batch_job_instance WHERE job_name=?) AND  exit_code IN (" + ss + ")";
        }
        return (Integer)this.jdbcTemplate.queryForObject(sql, args, types, Integer.class);
    }
}

