/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.model.License;
import com.viontech.keliu.runner.LicenseCheckRunner;
import com.viontech.keliu.util.JsonMessageUtil;
import com.viontech.keliu.util.SerialNumberUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/v1/license"})
public class LicenseController {
    private Logger logger = LoggerFactory.getLogger(LicenseController.class);
    @Autowired
    private LicenseCheckRunner licenseCheckRunner;

    @GetMapping(value={"/date"})
    public Object getLicenseDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return JsonMessageUtil.getSuccessJsonMsg((String)"\u83b7\u53d6\u6210\u529f", (Object)sdf.format(License.date));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/machineInfo"})
    public Object downloadMachineInfo(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/octet-stream");
        response.setHeader("content-type", "application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;fileName=machineInfo.txt");
        byte[] buffer = new byte[1024];
        ByteArrayInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            byte[] machineInfo = new ObjectMapper().writeValueAsBytes((Object)SerialNumberUtil.getAllSn());
            fis = new ByteArrayInputStream(machineInfo);
            bis = new BufferedInputStream(fis);
            ServletOutputStream os = response.getOutputStream();
            int i = bis.read(buffer);
            while (i != -1) {
                os.write(buffer, 0, i);
                i = bis.read(buffer);
            }
            System.out.println("success");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @PostMapping(value={"/upload"})
    @ResponseBody
    public Object uploadImg(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        String contentType = file.getContentType();
        String fileName = file.getOriginalFilename();
        try {
            this.logger.info("\u9879\u76ee\u6839\u76ee\u5f55{}", (Object)this.getJarRootPath());
            String jarFile = this.getJarRootPath();
            File licenseFile = new File(jarFile, "license.lic");
            Files.write(Paths.get(licenseFile.toURI()), file.getBytes(), new OpenOption[0]);
            this.licenseCheckRunner.run(new String[0]);
        }
        catch (Exception e) {
            this.logger.error("License\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            return JsonMessageUtil.getErrorJsonMsg((String)"\u4e0a\u4f20\u5931\u8d25");
        }
        return JsonMessageUtil.getSuccessJsonMsg((String)"\u4e0a\u4f20\u6b63\u5e38");
    }

    private String getJarRootPath() throws FileNotFoundException {
        String path = ResourceUtils.getURL((String)"classpath:").getPath();
        try {
            path = URLDecoder.decode(path, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        File rootFile = new File(path);
        if (!rootFile.exists()) {
            rootFile = new File("");
        }
        return rootFile.getAbsolutePath();
    }
}

