/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration;

import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.KryoCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonConfig {
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.port}")
    private Integer port;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.database:0}")
    private Integer database;

    @Bean
    public RedissonClient redissonClient() {
        Config config = new Config();
        SingleServerConfig singleServerConfig = config.useSingleServer();
        singleServerConfig.setAddress("redis://" + this.host + ":" + this.port);
        singleServerConfig.setPassword(this.password);
        singleServerConfig.setDatabase(this.database.intValue());
        singleServerConfig.setConnectionMinimumIdleSize(32);
        singleServerConfig.setConnectionPoolSize(128);
        singleServerConfig.setDnsMonitoringInterval(5000L);
        singleServerConfig.setSubscriptionConnectionMinimumIdleSize(1);
        singleServerConfig.setSubscriptionConnectionPoolSize(5);
        config.setCodec((Codec)new KryoCodec());
        config.setNettyThreads(0);
        config.setThreads(0);
        return Redisson.create((Config)config);
    }
}

