/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.tasklet;

import com.viontech.keliu.model.FaceStaData;
import com.viontech.keliu.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component(value="faceDataStaKey2RedisTasklet")
public class FaceDataStaKey2RedisTasklet
implements Tasklet {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private RedisTemplate redisTemplate;
    private final String SQL_DAY_GATE = "select DISTINCT gate_id as orgId,countdate as countDate from d_gate_day_face_recognition_sta where countdate > ?;";
    private final String SQL_DAY_ZONE = "select DISTINCT zone_id as orgId,countdate as countDate from d_zone_day_face_recognition_sta where countdate > ?;";
    private final String SQL_DAY_FLOOR = "select DISTINCT floor_id as orgId,countdate as countDate from d_floor_day_face_recognition_sta where countdate > ?;";
    private final String SQL_DAY_MALL = "select DISTINCT mall_id as orgId,countdate as countDate from d_mall_day_face_recognition_sta where countdate > ?;";
    private final String SQL_HOUR_GATE = "select DISTINCT gate_id as orgId,countdate as countDate,counttime as countTime from d_gate_hour_face_recognition_sta where countdate > ?;";
    private final String SQL_HOUR_ZONE = "select DISTINCT zone_id as orgId,countdate as countDate,counttime as countTime from d_zone_hour_face_recognition_sta where countdate > ?;";
    private final String SQL_HOUR_FLOOR = "select DISTINCT floor_id as orgId,countdate as countDate,counttime as countTime from d_floor_hour_face_recognition_sta where countdate > ?;";
    private final String SQL_HOUR_MALL = "select DISTINCT mall_id as orgId,countdate as countDate,counttime as countTime from d_mall_hour_face_recognition_sta where countdate > ?;";

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        sqlMap.put("faceStaKey:day:gate", "select DISTINCT gate_id as orgId,countdate as countDate from d_gate_day_face_recognition_sta where countdate > ?;");
        sqlMap.put("faceStaKey:day:zone", "select DISTINCT zone_id as orgId,countdate as countDate from d_zone_day_face_recognition_sta where countdate > ?;");
        sqlMap.put("faceStaKey:day:floor", "select DISTINCT floor_id as orgId,countdate as countDate from d_floor_day_face_recognition_sta where countdate > ?;");
        sqlMap.put("faceStaKey:day:mall", "select DISTINCT mall_id as orgId,countdate as countDate from d_mall_day_face_recognition_sta where countdate > ?;");
        sqlMap.put("faceStaKey:hour:gate", "select DISTINCT gate_id as orgId,countdate as countDate,counttime as countTime from d_gate_hour_face_recognition_sta where countdate > ?;");
        sqlMap.put("faceStaKey:hour:zone", "select DISTINCT zone_id as orgId,countdate as countDate,counttime as countTime from d_zone_hour_face_recognition_sta where countdate > ?;");
        sqlMap.put("faceStaKey:hour:floor", "select DISTINCT floor_id as orgId,countdate as countDate,counttime as countTime from d_floor_hour_face_recognition_sta where countdate > ?;");
        sqlMap.put("faceStaKey:hour:mall", "select DISTINCT mall_id as orgId,countdate as countDate,counttime as countTime from d_mall_hour_face_recognition_sta where countdate > ?;");
        SimpleDateFormat sdf = new SimpleDateFormat(DateUtil.FORMAT_SHORT);
        SimpleDateFormat sdfH = new SimpleDateFormat(DateUtil.FORMAT_YYYY_MM_DD_HH);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceStaData.class);
        Date d = DateUtil.addDays((Date)new Date(), (int)-5);
        for (Map.Entry entry : sqlMap.entrySet()) {
            List faceStaDatas = this.jdbcTemplate.query((String)entry.getValue(), (RowMapper)rowMapper, new Object[]{d});
            this.redisTemplate.delete(entry.getKey());
            for (FaceStaData faceStaData : faceStaDatas) {
                String value = "";
                value = faceStaData.getCountTime() == null ? faceStaData.getOrgId() + ":" + sdf.format(faceStaData.getCountDate()) : faceStaData.getOrgId() + ":" + sdfH.format(faceStaData.getCountTime());
                this.redisTemplate.boundSetOps(entry.getKey()).add(new Object[]{value});
            }
        }
        return RepeatStatus.FINISHED;
    }
}

