/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.tasklet;

import com.viontech.keliu.constants.SystemConstants;
import com.viontech.keliu.dao.DeviceDao;
import com.viontech.keliu.model.Device;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="deviceStatusUpdateTasklet")
public class DeviceStatusUpdateTasklet
implements Tasklet {
    private Logger logger = LoggerFactory.getLogger(DeviceStatusUpdateTasklet.class);
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private DeviceDao deviceDao;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Date nowDate = new Date();
        this.logger.info("\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u5f00\u59cb \u6267\u884c\u8bbe\u5907\u5fc3\u8df3\u6570\u636e\u68c0\u6d4b \u72b6\u6001\u66f4\u65b0 \u4efb\u52a1");
        BoundHashOperations boundHashOperations = this.redisTemplate.boundHashOps((Object)"device:lastALiveTime");
        List devices = this.deviceDao.selectAll();
        for (Device device : devices) {
            Short status;
            String serialnum = device.getSerialnum();
            Short currentStatus = status = device.getStatus();
            Object obj = boundHashOperations.get((Object)serialnum);
            if (obj != null) {
                Date date = (Date)obj;
                if (nowDate.getTime() - date.getTime() <= SystemConstants.DEVICE_ALIVE_CHECK_MILLIS) {
                    currentStatus = 1;
                } else if (status != 3) {
                    currentStatus = 0;
                }
            }
            if (status == currentStatus) continue;
            if (status == 0) {
                this.logger.info("\u8bbe\u5907{}\u4e0a\u7ebf", (Object)serialnum);
            } else {
                this.logger.info("\u8bbe\u5907{}\u79bb\u7ebf", (Object)serialnum);
            }
            this.deviceDao.updateDeviceStatus(currentStatus, device.getId());
        }
        this.logger.info("\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u7ed3\u675f \u6267\u884c\u8bbe\u5907\u5fc3\u8df3\u6570\u636e\u68c0\u6d4b \u72b6\u6001\u66f4\u65b0 \u4efb\u52a1");
        return RepeatStatus.FINISHED;
    }
}

