/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.tasklet;

import com.viontech.keliu.model.DeviceBackgroundData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component(value="deviceBackground2RedisTasklet")
public class DeviceBackground2RedisTasklet
implements Tasklet {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private RedisTemplate redisTemplate;
    private final String SQL_HEATMAP_BACKGROUND = "select DISTINCT channel_id as orgId,channel_serialnum as channelno from d_heatmap_background ;";

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        sqlMap.put("deviceBackgroundKey", "select DISTINCT channel_id as orgId,channel_serialnum as channelno from d_heatmap_background ;");
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(DeviceBackgroundData.class);
        for (Map.Entry entry : sqlMap.entrySet()) {
            List deviceBackgroundDatas = this.jdbcTemplate.query((String)entry.getValue(), (RowMapper)rowMapper);
            for (DeviceBackgroundData deviceBackgroundData : deviceBackgroundDatas) {
                String value = deviceBackgroundData.getChannelno();
                this.redisTemplate.boundSetOps(entry.getKey()).add(new Object[]{value});
            }
        }
        return RepeatStatus.FINISHED;
    }
}

