/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.tasklet;

import com.viontech.keliu.model.CountData;
import com.viontech.keliu.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component(value="countDataKey2RedisTasklet")
public class CountDataKey2RedisTasklet
implements Tasklet {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private RedisTemplate redisTemplate;
    private final String SQL_GATE_DAY = "select DISTINCT gate_id as orgId,counttime as countTime from d_gate_day_count_data where countdate > ?;";
    private final String SQL_GATE_HOUR = "select DISTINCT gate_id as orgId,counttime as countTime from d_gate_hour_count_data where countdate > ?;";
    private final String SQL_GATE_MINUTE = "select DISTINCT gate_id as orgId,counttime as countTime from d_gate_minute_count_data where countdate > ?;";
    private final String SQL_ZONE_DAY = "select DISTINCT zone_id as orgId,counttime as countTime from d_zone_day_count_data where countdate > ?;";
    private final String SQL_ZONE_HOUR = "select DISTINCT zone_id as orgId,counttime as countTime from d_zone_hour_count_data where countdate > ?;";
    private final String SQL_ZONE_MINUTE = "select DISTINCT zone_id as orgId,counttime as countTime from d_zone_minute_count_data where countdate > ?;";
    private final String SQL_FLOOR_DAY = "select DISTINCT floor_id as orgId,counttime as countTime from d_floor_day_count_data where countdate > ?;";
    private final String SQL_FLOOR_HOUR = "select DISTINCT floor_id as orgId,counttime as countTime from d_floor_hour_count_data where countdate > ?;";
    private final String SQL_FLOOR_MINUTE = "select DISTINCT floor_id as orgId,counttime as countTime from d_floor_minute_count_data where countdate > ?;";
    private final String SQL_MALL_DAY = "select DISTINCT mall_id as orgId,counttime as countTime from d_mall_day_count_data where countdate > ?;";
    private final String SQL_MALL_HOUR = "select DISTINCT mall_id as orgId,counttime as countTime from d_mall_hour_count_data where countdate > ?;";
    private final String SQL_MALL_MINUTE = "select DISTINCT mall_id as orgId,counttime as countTime from d_mall_minute_count_data where countdate > ?;";

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        sqlMap.put("countDataKey:gate:day", "select DISTINCT gate_id as orgId,counttime as countTime from d_gate_day_count_data where countdate > ?;");
        sqlMap.put("countDataKey:gate:hour", "select DISTINCT gate_id as orgId,counttime as countTime from d_gate_hour_count_data where countdate > ?;");
        sqlMap.put("countDataKey:gate:minute", "select DISTINCT gate_id as orgId,counttime as countTime from d_gate_minute_count_data where countdate > ?;");
        sqlMap.put("countDataKey:zone:day", "select DISTINCT zone_id as orgId,counttime as countTime from d_zone_day_count_data where countdate > ?;");
        sqlMap.put("countDataKey:zone:hour", "select DISTINCT zone_id as orgId,counttime as countTime from d_zone_hour_count_data where countdate > ?;");
        sqlMap.put("countDataKey:zone:minute", "select DISTINCT zone_id as orgId,counttime as countTime from d_zone_minute_count_data where countdate > ?;");
        sqlMap.put("countDataKey:floor:day", "select DISTINCT floor_id as orgId,counttime as countTime from d_floor_day_count_data where countdate > ?;");
        sqlMap.put("countDataKey:floor:hour", "select DISTINCT floor_id as orgId,counttime as countTime from d_floor_hour_count_data where countdate > ?;");
        sqlMap.put("countDataKey:floor:minute", "select DISTINCT floor_id as orgId,counttime as countTime from d_floor_minute_count_data where countdate > ?;");
        sqlMap.put("countDataKey:mall:day", "select DISTINCT mall_id as orgId,counttime as countTime from d_mall_day_count_data where countdate > ?;");
        sqlMap.put("countDataKey:mall:hour", "select DISTINCT mall_id as orgId,counttime as countTime from d_mall_hour_count_data where countdate > ?;");
        sqlMap.put("countDataKey:mall:minute", "select DISTINCT mall_id as orgId,counttime as countTime from d_mall_minute_count_data where countdate > ?;");
        SimpleDateFormat sdf = new SimpleDateFormat(DateUtil.FORMAT_LONG);
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(CountData.class);
        Date d = DateUtil.addDays((Date)new Date(), (int)-10);
        for (Map.Entry entry : sqlMap.entrySet()) {
            List countDatas = this.jdbcTemplate.query((String)entry.getValue(), (RowMapper)rowMapper, new Object[]{d});
            this.redisTemplate.delete(entry.getKey());
            BoundSetOperations boundSetOperations = this.redisTemplate.boundSetOps(entry.getKey());
            for (CountData countData : countDatas) {
                String value = countData.getOrgId() + ":" + sdf.format(countData.getCountTime());
                boundSetOperations.add(new Object[]{value});
            }
        }
        return RepeatStatus.FINISHED;
    }
}

