/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.batch.item.stream.BussinessValidItemStream;
import com.viontech.keliu.batch.item.writer.GateCountData2RedisWriter;
import com.viontech.keliu.content.CountDataContent;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.Gate;
import com.viontech.keliu.service.CountData2RedisService;
import com.viontech.keliu.service.OrgCacheService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="mallCountData2RedisWriter")
public class MallCountData2RedisWriter
extends BussinessValidItemStream<CountDataContent>
implements ItemStreamWriter<CountDataContent> {
    private final Logger logger = LoggerFactory.getLogger(GateCountData2RedisWriter.class);
    @Resource
    private CountData2RedisService countData2RedisService;
    @Resource
    private OrgCacheService orgCacheService;
    @Value(value="${vion.time-offset.mall-day:0}")
    private int mallDayTimeOffset;

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        super.open(executionContext);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
    }

    public void close() throws ItemStreamException {
        super.close();
    }

    protected Date getCounttime(CountDataContent countDataContent) {
        return countDataContent.getCountdate();
    }

    protected Long getMallId(CountDataContent countDataContent) {
        return countDataContent.getMallId();
    }

    public void write(List<? extends CountDataContent> items) throws Exception {
        Map channelMap = this.orgCacheService.getChannelMap();
        Map gate2MallMap = this.orgCacheService.getGate2MallMap();
        Map gateMap = this.orgCacheService.getGateMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        for (CountDataContent countDataContent : items) {
            Gate gate;
            Long mallId;
            Channel channel = (Channel)channelMap.get(countDataContent.getChannelno());
            if (channel == null || channel.getType() != null && channel.getType() == 1 || channel.getGateId() == null || (mallId = (Long)gate2MallMap.get(String.valueOf(channel.getGateId()))) == null) continue;
            countDataContent.setMallId(mallId);
            if (!this.isValid((Object)countDataContent) || (gate = (Gate)gateMap.get(String.valueOf(channel.getGateId()))) == null) continue;
            this.countData2RedisService.mallCountData2Redis(channel, mallId, gate, countDataContent.getCreateTime(), countDataContent.getInnum(), countDataContent.getOutnum());
        }
    }
}

