/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.util.Assert;

public abstract class InsertOrUpdateOrIgnoreItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    private Logger logger = LoggerFactory.getLogger(InsertOrUpdateOrIgnoreItemWriter.class);
    private String insertSql;
    private String updateSql;
    private DataSource dataSource;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public InsertOrUpdateOrIgnoreItemWriter(String insertSql, String updateSql, DataSource dataSource) {
        this.insertSql = insertSql;
        this.updateSql = updateSql;
        this.dataSource = dataSource;
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    public void write(List<? extends T> items) throws Exception {
        int value;
        if (items.size() == 0) {
            return;
        }
        ArrayList<T> updateList = new ArrayList<T>();
        ArrayList<T> insertList = new ArrayList<T>();
        for (T item : items) {
            if (this.needInsert(item) == 1) {
                insertList.add(item);
                continue;
            }
            if (this.needInsert(item) != 2) continue;
            updateList.add(item);
        }
        int[] insertCounts = null;
        int[] updateCounts = null;
        if (insertList.size() > 0) {
            SqlParameterSource[] insertSources = SqlParameterSourceUtils.createBatch((Object[])insertList.toArray());
            insertCounts = this.namedParameterJdbcTemplate.batchUpdate(this.insertSql, insertSources);
        }
        if (updateList.size() > 0) {
            SqlParameterSource[] updateSources = SqlParameterSourceUtils.createBatch((Object[])updateList.toArray());
            updateCounts = this.namedParameterJdbcTemplate.batchUpdate(this.updateSql, updateSources);
        }
        if (insertCounts != null && insertCounts.length > 0) {
            for (int i = 0; i < insertCounts.length; ++i) {
                value = insertCounts[i];
                if (value != 0) continue;
                this.logger.error("Item " + i + " of " + insertCounts.length + " did not update any rows: [" + insertList.get(i).toString() + "]", (Object)1);
            }
        }
        if (updateCounts != null && updateCounts.length > 0) {
            for (int i = 0; i < updateCounts.length; ++i) {
                value = updateCounts[i];
                if (value != 0) continue;
                this.logger.error("Item " + i + " of " + updateCounts.length + " did not update any rows: [" + updateList.get(i).toString() + "]", (Object)1);
            }
        }
    }

    protected abstract int needInsert(T var1);

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.namedParameterJdbcTemplate, (String)"A DataSource or a NamedParameterJdbcTemplate is required.");
    }
}

