/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.JdbcBatchItemWriter;
import org.springframework.beans.factory.InitializingBean;

public abstract class InsertOrUpdateItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    JdbcBatchItemWriter<T> updateWriter = null;
    JdbcBatchItemWriter<T> insertWriter = null;

    public InsertOrUpdateItemWriter(String insertSql, String updateSql, DataSource dataSource) {
        if (insertSql != null && !insertSql.isEmpty()) {
            this.insertWriter = new JdbcBatchItemWriter();
            this.insertWriter.setDataSource(dataSource);
            this.insertWriter.setSql(insertSql);
        }
        if (updateSql != null && !updateSql.isEmpty()) {
            this.updateWriter = new JdbcBatchItemWriter();
            this.updateWriter.setDataSource(dataSource);
            this.updateWriter.setSql(updateSql);
            this.updateWriter.setAssertUpdates(false);
        }
    }

    public void write(List<? extends T> items) throws Exception {
        ArrayList<T> updateList = new ArrayList<T>();
        ArrayList<T> insertList = new ArrayList<T>();
        for (T item : items) {
            if (this.needInsert(item)) {
                insertList.add(item);
                continue;
            }
            updateList.add(item);
        }
        if (!insertList.isEmpty() && this.insertWriter != null) {
            this.insertWriter.write(insertList);
        }
        if (!updateList.isEmpty() && this.updateWriter != null) {
            this.updateWriter.write(updateList);
        }
    }

    protected abstract boolean needInsert(T var1);

    public void setDataSource(DataSource dataSource) {
        if (this.insertWriter != null) {
            this.insertWriter.setDataSource(dataSource);
        }
        if (this.updateWriter != null) {
            this.updateWriter.setDataSource(dataSource);
        }
    }

    public void setItemPreparedStatementSetter(ItemPreparedStatementSetter<T> itemPreparedStatementSetter) {
        if (this.updateWriter != null) {
            this.updateWriter.setItemPreparedStatementSetter(itemPreparedStatementSetter);
        }
        if (this.insertWriter != null) {
            this.insertWriter.setItemPreparedStatementSetter(itemPreparedStatementSetter);
        }
    }

    public void setItemSqlParameterSourceProvider(ItemSqlParameterSourceProvider<T> itemSqlParameterSourceProvider) {
        if (this.updateWriter != null) {
            this.updateWriter.setItemSqlParameterSourceProvider(itemSqlParameterSourceProvider);
        }
        if (this.insertWriter != null) {
            this.insertWriter.setItemSqlParameterSourceProvider(itemSqlParameterSourceProvider);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.updateWriter != null) {
            this.updateWriter.afterPropertiesSet();
        }
        if (this.insertWriter != null) {
            this.insertWriter.afterPropertiesSet();
        }
    }
}

