/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.batch.item.stream.BussinessValidItemStream;
import com.viontech.keliu.content.CountDataContent;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.service.CountData2RedisService;
import com.viontech.keliu.service.OrgCacheService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="gateCountData2RedisWriter")
public class GateCountData2RedisWriter
extends BussinessValidItemStream<CountDataContent>
implements ItemStreamWriter<CountDataContent> {
    private final Logger logger = LoggerFactory.getLogger(GateCountData2RedisWriter.class);
    @Resource
    private CountData2RedisService countData2RedisService;
    @Resource
    private OrgCacheService orgCacheService;
    @Value(value="${vion.time-offset.mall-day:0}")
    private int mallDayTimeOffset;

    protected Date getCounttime(CountDataContent countDataContent) {
        return countDataContent.getCountdate();
    }

    protected Long getMallId(CountDataContent countDataContent) {
        return countDataContent.getMallId();
    }

    public void write(List<? extends CountDataContent> items) throws Exception {
        Map channelMap = this.orgCacheService.getChannelMap();
        for (CountDataContent countDataContent : items) {
            Long gateId;
            Channel channel = (Channel)channelMap.get(countDataContent.getChannelno());
            if (channel == null) continue;
            countDataContent.setMallId(channel.getMallId());
            if (!this.isValid((Object)countDataContent) || channel.getType() != null && channel.getType() == 1 || (gateId = channel.getGateId()) == null) continue;
            this.countData2RedisService.gateCountData2Redis(channel, gateId, countDataContent.getCreateTime(), countDataContent.getInnum(), countDataContent.getOutnum());
        }
    }
}

