/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.batch.item.writer.AbstractFaceDataSta2Redis;
import com.viontech.keliu.batch.item.writer.FaceDataSta2RedisWriter;
import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.util.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component(value="faceHourDataSta2RedisWriter")
public class FaceHourDataSta2RedisWriter
extends AbstractFaceDataSta2Redis {
    private final Logger logger = LoggerFactory.getLogger(FaceDataSta2RedisWriter.class);
    @Resource
    private JdbcTemplate jdbcTemplate;

    RowCallbackHandler getFaceStaRowCallBackHandler(BoundHashOperations<Object, String, Object> boundHashOps) {
        return rs -> this.putFaceSta2Redis(boundHashOps, rs);
    }

    void loadMallFaceSta(FaceDataContent item, Long mallId, String dateStr, BoundHashOperations boundHashOps) {
        Date countTime = this.dateStr2Date(dateStr);
        if (countTime == null) {
            return;
        }
        String sql = "SELECT * FROM d_mall_hour_face_recognition_sta WHERE  countdate = ? AND mall_id=? AND counttime=?";
        this.loadFaceSta("loadMallHourFaceSta:" + mallId, boundHashOps, sql, new Object[]{item.getCountDate(), mallId, countTime});
    }

    void loadGateFaceSta(FaceDataContent item, Long gateId, String dateStr, BoundHashOperations boundHashOps) {
        Date countTime = this.dateStr2Date(dateStr);
        if (countTime == null) {
            return;
        }
        String sql = "SELECT * FROM d_gate_hour_face_recognition_sta WHERE  countdate = ? AND mall_id=? and gate_id=? AND counttime=?";
        this.loadFaceSta("loadGateHourFaceSta:" + gateId, boundHashOps, sql, new Object[]{item.getCountDate(), item.getMallId(), gateId, countTime});
    }

    void loadFloorFaceSta(FaceDataContent item, Long floorId, String dateStr, BoundHashOperations boundHashOps) {
        Date countTime = this.dateStr2Date(dateStr);
        if (countTime == null) {
            return;
        }
        String sql = "SELECT * FROM d_floor_hour_face_recognition_sta WHERE countdate = ? AND mall_id=? AND floor_id  = ? AND counttime=?";
        this.loadFaceSta("loadFloorHourFaceSta:" + floorId, boundHashOps, sql, new Object[]{item.getCountDate(), item.getMallId(), floorId, countTime});
    }

    protected void loadZoneFaceSta(FaceDataContent item, Long zoneId, String dateStr, BoundHashOperations boundHashOps) {
        Date countTime = this.dateStr2Date(dateStr);
        if (countTime == null) {
            return;
        }
        String sql = "SELECT * FROM d_zone_hour_face_recognition_sta WHERE  countdate = ? AND mall_id=? AND zone_id= ? AND counttime=?";
        this.loadFaceSta("loadZoneHourFaceSta:" + zoneId, boundHashOps, sql, new Object[]{item.getCountDate(), item.getMallId(), zoneId, countTime});
    }

    boolean needLoadPersonUnids(Date counttime) {
        long diff = Math.abs(System.currentTimeMillis() - DateUtil.truncate((Date)new Date(), (int)11).getTime());
        return diff > 600000L;
    }

    String dateType() {
        return "hour";
    }

    protected List<FaceRecognition> getFaceRecognitionList(Date date, Long mallId) {
        date = DateUtil.truncate((Date)date, (int)11);
        return this.jdbcTemplate.query("SELECT person_unid,gate_id FROM d_face_recognition WHERE countdate = ? AND mall_id=? AND direction=1 AND  counttime >=? AND counttime < ? ", new Object[]{date, mallId, date, DateUtil.addHours((Date)date, (int)1)}, (RowMapper)new BeanPropertyRowMapper(FaceRecognition.class));
    }

    String getDateStr(Date date) {
        return DateUtil.format((String)"yyyyMMddHH", (Date)date);
    }

    private Date dateStr2Date(String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHH");
        try {
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

