/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.batch.item.writer.AbstractFaceDataSta2Redis;
import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component(value="faceDataSta2RedisWriter")
public class FaceDataSta2RedisWriter
extends AbstractFaceDataSta2Redis {
    private final Logger logger = LoggerFactory.getLogger(FaceDataSta2RedisWriter.class);

    void loadMallFaceSta(FaceDataContent item, Long mallId, String dateStr, BoundHashOperations boundHashOps) {
        String sql = "SELECT *  FROM d_mall_day_face_recognition_sta WHERE mall_id=? AND countdate=? LIMIT 1";
        this.loadFaceSta("loadMallDayFaceSta:" + mallId, boundHashOps, sql, new Object[]{mallId, item.getCountDate()});
    }

    void loadGateFaceSta(FaceDataContent item, Long gateId, String dateStr, BoundHashOperations boundHashOps) {
        String sql = "SELECT *  FROM d_gate_day_face_recognition_sta WHERE mall_id=? AND countdate=? and gate_id = ? limit 1";
        this.loadFaceSta("loadGateDayFaceSta:" + gateId, boundHashOps, sql, new Object[]{item.getMallId(), item.getCountDate(), gateId});
    }

    void loadFloorFaceSta(FaceDataContent item, Long floorId, String dateStr, BoundHashOperations boundHashOps) {
        String sql = "SELECT *  FROM d_floor_day_face_recognition_sta WHERE mall_id=? AND countdate=? and floor_id=? LIMIT 1";
        this.loadFaceSta("loadFloorDayFaceSta:" + floorId, boundHashOps, sql, new Object[]{item.getMallId(), item.getCountDate(), floorId});
    }

    void loadZoneFaceSta(FaceDataContent item, Long zoneId, String dateStr, BoundHashOperations boundHashOps) {
        String sql = "SELECT *  FROM d_zone_day_face_recognition_sta WHERE mall_id=? AND countdate=? and zone_id=? LIMIT 1";
        this.loadFaceSta("loadZoneDayFaceSta:" + zoneId, boundHashOps, sql, new Object[]{item.getMallId(), item.getCountDate(), zoneId});
    }

    protected List<FaceRecognition> getFaceRecognitionList(Date date, Long mallId) {
        return this.jdbcTemplate.query("SELECT person_unid,gate_id FROM d_face_recognition WHERE mall_id=? AND countdate=? AND direction=1", new Object[]{mallId, date}, (RowMapper)new BeanPropertyRowMapper(FaceRecognition.class));
    }

    String dateType() {
        return "day";
    }

    RowCallbackHandler getFaceStaRowCallBackHandler(BoundHashOperations<Object, String, Object> boundHashOps) {
        return rs -> {
            String[] femaleStage;
            int count;
            int i;
            String[] maleStage;
            super.putFaceSta2Redis(boundHashOps, rs);
            boundHashOps.increment((Object)"newCustomCount", (long)rs.getInt("new_custom_count"));
            boundHashOps.increment((Object)"newMaleCount", (long)rs.getInt("new_male_count"));
            boundHashOps.increment((Object)"newFemaleCount", (long)rs.getInt("new_female_count"));
            boundHashOps.increment((Object)"regularCustomCount", (long)rs.getInt("regular_custom_count"));
            boundHashOps.increment((Object)"regularMaleCount", (long)rs.getInt("regular_male_count"));
            boundHashOps.increment((Object)"regularFemaleCount", (long)rs.getInt("regular_female_count"));
            if (rs.getString("new_male_stage") != null) {
                maleStage = rs.getString("new_male_stage").split(",");
                for (i = 0; i < maleStage.length; ++i) {
                    count = Integer.parseInt(maleStage[i].trim());
                    if (count <= 0) continue;
                    boundHashOps.increment((Object)("newMaleDetail" + i), (long)count);
                }
            }
            if (rs.getString("new_female_stage") != null) {
                femaleStage = rs.getString("new_female_stage").split(",");
                for (i = 0; i < femaleStage.length; ++i) {
                    count = Integer.parseInt(femaleStage[i].trim());
                    if (count <= 0) continue;
                    boundHashOps.increment((Object)("newFemaleDetail" + i), (long)count);
                }
            }
            if (rs.getString("regular_male_stage") != null) {
                maleStage = rs.getString("regular_male_stage").split(",");
                for (i = 0; i < maleStage.length; ++i) {
                    count = Integer.parseInt(maleStage[i].trim());
                    if (count <= 0) continue;
                    boundHashOps.increment((Object)("regularMaleDetail" + i), (long)count);
                }
            }
            if (rs.getString("regular_female_stage") != null) {
                femaleStage = rs.getString("regular_female_stage").split(",");
                for (i = 0; i < femaleStage.length; ++i) {
                    count = Integer.parseInt(femaleStage[i].trim());
                    if (count <= 0) continue;
                    boundHashOps.increment((Object)("regularFemaleDetail" + i), (long)count);
                }
            }
        };
    }

    String getDateStr(Date date) {
        return DateUtil.format((String)"yyyyMMdd", (Date)date);
    }

    boolean needLoadPersonUnids(Date counttime) {
        return true;
    }
}

