/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.batch.item.stream.BussinessValidItemStream;
import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.Gate;
import com.viontech.keliu.model.MallOpentime;
import com.viontech.keliu.service.CountData2RedisService;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.util.DateUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component(value="faceData2CountData2RedisWriter")
public class FaceData2CountData2RedisWriter
implements ItemStreamWriter<FaceDataContent> {
    Logger logger = LoggerFactory.getLogger(FaceData2CountData2RedisWriter.class);
    @Resource
    private CountData2RedisService countData2RedisService;
    @Resource
    private OrgCacheService orgCacheService;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final String SQL_SEL_OPENTIME = "SELECT mall_id,account_id,start_time,end_time,start_date,end_date,type FROM b_mall_opentime";

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        this.updateOpenTime(executionContext);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        this.updateOpenTime(executionContext);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("openTimeMap");
        this.executionContextThreadLocal.remove();
    }

    public void write(List<? extends FaceDataContent> items) throws Exception {
        Map gateMap = this.orgCacheService.getGateMap();
        Map channelMap = this.orgCacheService.getChannelMap();
        Map gate2MallMap = this.orgCacheService.getGate2MallMap();
        Map gate2ZoneMap = this.orgCacheService.getGate2ZoneMap();
        Map zoneMap = this.orgCacheService.getZoneMap();
        Map floor2ZoneMap = this.orgCacheService.getGate2FloorMap();
        for (FaceDataContent faceDataContent : items) {
            List floorGates;
            List zoneGates;
            Channel channel;
            Gate gate = (Gate)gateMap.get(String.valueOf(faceDataContent.getGateId()));
            if (gate == null || gate.getType() != 3) continue;
            String channelNo = faceDataContent.getChannelSerialnum();
            Date createTime = faceDataContent.getCountDate();
            int inNum = 0;
            int outNum = 0;
            if (faceDataContent.getDirection() == 1) {
                inNum = 1;
            } else if (faceDataContent.getDirection() == -1) {
                outNum = 1;
            }
            if ((channel = (Channel)channelMap.get(channelNo)) == null || channel.getGateId() == null || !this.isValid(channel.getMallId(), createTime)) continue;
            this.countData2RedisService.gateCountData2Redis(channel, channel.getGateId(), createTime, inNum, outNum);
            Long mallId = (Long)gate2MallMap.get(String.valueOf(channel.getGateId()));
            if (mallId != null) {
                this.countData2RedisService.mallCountData2Redis(channel, mallId, gate, createTime, inNum, outNum);
            }
            if ((zoneGates = (List)gate2ZoneMap.get(String.valueOf(channel.getGateId()))) != null && zoneGates.size() > 0) {
                this.countData2RedisService.zoneCountData2Redis(zoneMap, channel, zoneGates, createTime, inNum, outNum);
            }
            if ((floorGates = (List)floor2ZoneMap.get(String.valueOf(channel.getGateId()))) == null || floorGates.size() <= 0) continue;
            this.countData2RedisService.floorCountData2Redis(channel, floorGates, createTime, inNum, outNum);
        }
    }

    private void updateOpenTime(ExecutionContext executionContext) {
        List mallOpentimes = this.jdbcTemplate.query("SELECT mall_id,account_id,start_time,end_time,start_date,end_date,type FROM b_mall_opentime", (RowMapper)new BeanPropertyRowMapper(MallOpentime.class));
        HashMap opentimeMap = new HashMap();
        mallOpentimes.forEach(item -> opentimeMap.put(item.getMallId(), item));
        executionContext.put("openTimeMap", opentimeMap);
    }

    public boolean isValid(Long mallId, Date countTime) {
        Date endTime;
        Map openTimeMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("openTimeMap");
        MallOpentime mallopenTime = (MallOpentime)openTimeMap.get(mallId);
        if (mallopenTime == null) {
            return true;
        }
        Date startTime = mallopenTime.getStartTime();
        if (startTime.equals(endTime = mallopenTime.getEndTime())) {
            return true;
        }
        if (BussinessValidItemStream.isInBusiness((Date)countTime, (Date)startTime, (Date)endTime)) {
            return true;
        }
        this.logger.debug(mallId + "\t\u8425\u4e1a\u65f6\u95f4\u8303\u56f4\u5916\u6570\u636e-\u8df3\u8fc7,mallId:" + mallId + "\u7edf\u8ba1\u65f6\u95f4:" + DateUtil.format((String)DateUtil.FORMAT_YYYY_MM_DD_HH_MM, (Date)countTime));
        return false;
    }
}

