/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.model.FloorGate;
import com.viontech.keliu.model.Zone;
import com.viontech.keliu.model.ZoneGate;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.service.RedissonService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public abstract class AbstractFaceDataSta2Redis
implements ItemStreamWriter<FaceDataContent> {
    private Logger logger = LoggerFactory.getLogger(AbstractFaceDataSta2Redis.class);
    @Resource
    protected OrgCacheService orgCacheService;
    @Resource
    protected RedisTemplate redisTemplate;
    @Resource
    protected RedissonService redissonService;
    @Resource
    protected JdbcTemplate jdbcTemplate;

    public void open(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void close() throws ItemStreamException {
    }

    public void write(List<? extends FaceDataContent> items) throws Exception {
        Map gate2ZoneMap = this.orgCacheService.getGate2ZoneMap();
        Map zoneMap = this.orgCacheService.getZoneMap();
        Map gate2MallMap = this.orgCacheService.getGate2MallMap();
        Map floor2ZoneMap = this.orgCacheService.getGate2FloorMap();
        for (FaceDataContent faceDataContent : items) {
            List zoneGates;
            List floorGates;
            if (faceDataContent.getDirection() != 1) {
                this.logger.debug("\u65b9\u5411\u4e0d\u662f\u8fdb,\u8df3\u8fc7");
                continue;
            }
            Long gateId = faceDataContent.getGateId();
            if (gateId == null) {
                this.logger.warn("\u8bbe\u5907{}\u6ca1\u6709\u7ed1\u5b9a\u76d1\u63a7\u70b9", (Object)faceDataContent.getChannelSerialnum());
                continue;
            }
            Date counttime = faceDataContent.getCountDate();
            String dateStr = this.getDateStr(counttime);
            Long mallId = faceDataContent.getMallId();
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
            map.put("mallId", faceDataContent.getMallId());
            map.put("accountId", faceDataContent.getAccountId());
            map.put("countDate", faceDataContent.getCountDate());
            map.put("gateId", gateId);
            map.put("countTime", counttime);
            String faceStaKey = this.buildFaceKey("gate", dateStr, gateId);
            BoundHashOperations boundHashOps = this.redisTemplate.boundHashOps((Object)faceStaKey);
            this.loadGateFaceSta(faceDataContent, gateId, dateStr, boundHashOps);
            String gatePersonUnidKey = this.buildPersonUnidKey("gate", dateStr, gateId);
            this.incrementValue(boundHashOps, faceDataContent, this.isRepeatPersonUnid(gatePersonUnidKey, faceDataContent, dateStr, counttime));
            boundHashOps.putAll(map);
            if (gate2MallMap.containsKey(String.valueOf(gateId))) {
                faceStaKey = this.buildFaceKey("mall", dateStr, mallId);
                boundHashOps = this.redisTemplate.boundHashOps((Object)faceStaKey);
                this.loadMallFaceSta(faceDataContent, mallId, dateStr, boundHashOps);
                String mallPersonUnidKey = this.buildPersonUnidKey("mall", dateStr, mallId);
                this.incrementValue(boundHashOps, faceDataContent, this.isRepeatPersonUnid(mallPersonUnidKey, faceDataContent, dateStr, counttime));
                boundHashOps.putAll(map);
            }
            if ((floorGates = (List)floor2ZoneMap.get(String.valueOf(gateId))) != null && floorGates.size() > 0) {
                for (FloorGate floorGate : floorGates) {
                    int type = floorGate.getType();
                    if (type != 1) continue;
                    long floorId = floorGate.getFloorId();
                    map.put("floorId", Long.valueOf(floorId));
                    faceStaKey = this.buildFaceKey("floor", dateStr, Long.valueOf(floorId));
                    boundHashOps = this.redisTemplate.boundHashOps((Object)faceStaKey);
                    this.loadFloorFaceSta(faceDataContent, Long.valueOf(floorId), dateStr, boundHashOps);
                    String floorPersonUnidKey = this.buildPersonUnidKey("floor", dateStr, Long.valueOf(floorId));
                    this.incrementValue(boundHashOps, faceDataContent, this.isRepeatPersonUnid(floorPersonUnidKey, faceDataContent, dateStr, counttime));
                    boundHashOps.putAll(map);
                }
            }
            if ((zoneGates = (List)gate2ZoneMap.get(String.valueOf(gateId))) == null || zoneGates.size() <= 0) continue;
            for (ZoneGate zoneGate : zoneGates) {
                int type = zoneGate.getType();
                if (type != 1) continue;
                long zoneId = zoneGate.getZoneId();
                map.put("zoneId", Long.valueOf(zoneId));
                Zone zone = (Zone)zoneMap.get(String.valueOf(zoneId));
                if (zone == null) {
                    this.logger.info("zoneId {} null , zoneMap size is {}", (Object)zoneId, (Object)zoneMap.size());
                } else {
                    map.put("floorId", Long.valueOf(zone.getFloorId()));
                }
                faceStaKey = this.buildFaceKey("zone", dateStr, Long.valueOf(zoneId));
                boundHashOps = this.redisTemplate.boundHashOps((Object)faceStaKey);
                this.loadZoneFaceSta(faceDataContent, Long.valueOf(zoneId), dateStr, boundHashOps);
                String zonePersonUnidKey = this.buildPersonUnidKey("zone", dateStr, Long.valueOf(zoneId));
                this.incrementValue(boundHashOps, faceDataContent, this.isRepeatPersonUnid(zonePersonUnidKey, faceDataContent, dateStr, counttime));
                boundHashOps.putAll(map);
            }
        }
    }

    void increment(BoundHashOperations boundHashOps, FaceDataContent faceDataContent, boolean repeatPersonUnid, boolean infoValidData) {
        String genderStr = faceDataContent.getGender() == 1 ? "male" : "female";
        String infoKey = genderStr + "Detail" + faceDataContent.getAge();
        boundHashOps.increment((Object)"personMantime", 1L);
        boundHashOps.increment((Object)"flagUpdate", 1L);
        if (faceDataContent.getPersonType() == null || faceDataContent.getPersonType() != 1) {
            if (infoValidData) {
                String manTimeKey = genderStr + "Mantime";
                boundHashOps.increment((Object)manTimeKey, 1L);
            }
            boundHashOps.increment((Object)"customMantime", 1L);
        } else {
            boundHashOps.increment((Object)"staffMantime", 1L);
        }
        boundHashOps.expire(2L, TimeUnit.HOURS);
        if (repeatPersonUnid) {
            return;
        }
        boundHashOps.increment((Object)"personCount", 1L);
        if (faceDataContent.getPersonType() == null || faceDataContent.getPersonType() != 1) {
            boundHashOps.increment((Object)"customCount", 1L);
            if (infoValidData) {
                String countKey = genderStr + "Count";
                boundHashOps.increment((Object)countKey, 1L);
                boundHashOps.increment((Object)infoKey, 1L);
            }
        } else {
            boundHashOps.increment((Object)"staffCount", 1L);
        }
    }

    void loadPersonUnid(String dateKeyStr, Long mallId, Date countDate) {
        Map gate2FloorMap = this.orgCacheService.getGate2FloorMap();
        Map gate2ZoneMap = this.orgCacheService.getGate2ZoneMap();
        ArrayList<String> mallPersons = new ArrayList<String>();
        HashMap<Long, List> gatePersonMap = new HashMap<Long, List>();
        HashMap<Long, List> zonePersonMap = new HashMap<Long, List>();
        HashMap<Long, List> floorPersonMap = new HashMap<Long, List>();
        List faceList = this.getFaceRecognitionList(countDate, mallId);
        for (FaceRecognition face : faceList) {
            List floorGates;
            String personUnid = face.getPersonUnid();
            mallPersons.add(personUnid);
            Long gateId = face.getGateId();
            List gatePersonList = gatePersonMap.computeIfAbsent(gateId, k -> new ArrayList());
            gatePersonList.add(personUnid);
            List zoneGates = (List)gate2ZoneMap.get(String.valueOf(gateId));
            if (zoneGates != null) {
                for (ZoneGate zoneGate : zoneGates) {
                    List zonePersonList = zonePersonMap.computeIfAbsent(zoneGate.getZoneId(), k -> new ArrayList());
                    zonePersonList.add(personUnid);
                }
            }
            if ((floorGates = (List)gate2FloorMap.get(String.valueOf(gateId))) == null) continue;
            for (FloorGate floorGate : floorGates) {
                List floorPersonList = floorPersonMap.computeIfAbsent(floorGate.getGateId(), k -> new ArrayList());
                floorPersonList.add(personUnid);
            }
        }
        String mallPersonUnidKey = this.buildPersonUnidKey("mall", dateKeyStr, mallId);
        if (mallPersons.isEmpty()) {
            this.redisTemplate.boundSetOps((Object)mallPersonUnidKey).add(new Object[]{"flag"});
        } else {
            this.redisTemplate.boundSetOps((Object)mallPersonUnidKey).add(mallPersons.toArray());
        }
        this.addPersonUnid(this.redisTemplate, gatePersonMap, "gate", dateKeyStr);
        this.addPersonUnid(this.redisTemplate, zonePersonMap, "zone", dateKeyStr);
        this.addPersonUnid(this.redisTemplate, floorPersonMap, "floor", dateKeyStr);
    }

    private void addPersonUnid(RedisTemplate redisTemplate, Map<Long, List<String>> personMap, String orgType, String dateStr) {
        for (Map.Entry<Long, List<String>> entry : personMap.entrySet()) {
            String key = this.buildPersonUnidKey(orgType, dateStr, entry.getKey());
            if (entry.getValue() == null || entry.getValue().isEmpty()) {
                redisTemplate.boundSetOps((Object)key).add(new Object[]{"flag"});
            } else {
                redisTemplate.boundSetOps((Object)key).add(entry.getValue().toArray());
            }
            redisTemplate.expire((Object)key, 2L, TimeUnit.HOURS);
        }
    }

    protected void loadFaceSta(String lockKey, BoundHashOperations boundHashOps, String sql, Object[] args) {
        String key = String.valueOf(boundHashOps.getKey());
        if (!this.redisTemplate.expire((Object)key, 2L, TimeUnit.HOURS).booleanValue()) {
            this.redissonService.lockAndRun(lockKey, Long.valueOf(60L), Long.valueOf(59L), () -> {
                if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
                    this.logger.debug("\u5f00\u59cb\u52a0\u8f7d personUnid\u7f13\u5b58 key:{}", (Object)key);
                    this.jdbcTemplate.query(sql, args, this.getFaceStaRowCallBackHandler(boundHashOps));
                }
            });
        }
    }

    abstract RowCallbackHandler getFaceStaRowCallBackHandler(BoundHashOperations<Object, String, Object> var1);

    void putFaceSta2Redis(BoundHashOperations<Object, String, Object> boundHashOps, ResultSet rs) throws SQLException {
        int count;
        int i;
        boundHashOps.increment((Object)"personMantime", (long)rs.getInt("person_mantime"));
        boundHashOps.increment((Object)"personCount", (long)rs.getInt("person_count"));
        boundHashOps.increment((Object)"customMantime", (long)rs.getInt("custom_mantime"));
        boundHashOps.increment((Object)"customCount", (long)rs.getInt("custom_count"));
        boundHashOps.increment((Object)"staffCount", (long)rs.getInt("staff_count"));
        boundHashOps.increment((Object)"staffMantime", (long)rs.getInt("staff_mantime"));
        boundHashOps.increment((Object)"maleMantime", (long)rs.getInt("male_mantime"));
        boundHashOps.increment((Object)"maleCount", (long)rs.getInt("male_count"));
        boundHashOps.increment((Object)"femaleMantime", (long)rs.getInt("female_mantime"));
        boundHashOps.increment((Object)"femaleCount", (long)rs.getInt("female_count"));
        String[] maleStage = rs.getString("male_stage").split(",");
        String[] femaleStage = rs.getString("female_stage").split(",");
        for (i = 0; i < maleStage.length; ++i) {
            count = Integer.parseInt(maleStage[i].trim());
            if (count <= 0) continue;
            boundHashOps.increment((Object)("maleDetail" + i), (long)count);
        }
        for (i = 0; i < femaleStage.length; ++i) {
            count = Integer.parseInt(femaleStage[i].trim());
            if (count <= 0) continue;
            boundHashOps.increment((Object)("femaleDetail" + i), (long)count);
        }
    }

    private boolean isRepeatPersonUnid(String key, FaceDataContent item, String dateStr, Date counttime) {
        long result;
        if (!this.redisTemplate.expire((Object)key, 2L, TimeUnit.HOURS).booleanValue()) {
            this.redissonService.lockAndRun("loadPersonUnidHour", Long.valueOf(300L), Long.valueOf(299L), () -> {
                if (!this.redisTemplate.hasKey((Object)key).booleanValue() && this.needLoadPersonUnids(counttime)) {
                    this.logger.debug("\u5f00\u59cb\u52a0\u8f7d  <\u5c0f\u65f6\u7ea7> personUnid key:{}", (Object)key);
                    this.loadPersonUnid(dateStr, item.getMallId(), item.getCountDate());
                }
            });
        }
        return (result = this.redisTemplate.opsForSet().add((Object)key, new Object[]{item.getPersonId()}).longValue()) <= 0L;
    }

    private void incrementValue(BoundHashOperations boundHashOps, FaceDataContent faceDataContent, boolean repeatPersonUnid) {
        this.logger.debug("\u5f00\u59cb\u7d2f\u52a0\u6570\u636e:{}", boundHashOps.getKey());
        boolean infoValidData = false;
        if (faceDataContent.getGender() >= 0 && faceDataContent.getAge() >= 0) {
            infoValidData = true;
        }
        this.increment(boundHashOps, faceDataContent, repeatPersonUnid, infoValidData);
    }

    abstract boolean needLoadPersonUnids(Date var1);

    private String buildFaceKey(String orgType, String timeStrKey, Long orgId) {
        return "faceSta:" + this.dateType() + ":" + orgType + ":" + timeStrKey + ":" + orgId;
    }

    private String buildPersonUnidKey(String orgType, String timeStrKey, Long orgId) {
        return "personUnid:" + this.dateType() + ":" + orgType + ":" + timeStrKey + ":" + orgId;
    }

    abstract String dateType();

    abstract List<FaceRecognition> getFaceRecognitionList(Date var1, Long var2);

    abstract void loadMallFaceSta(FaceDataContent var1, Long var2, String var3, BoundHashOperations var4);

    abstract void loadGateFaceSta(FaceDataContent var1, Long var2, String var3, BoundHashOperations var4);

    abstract void loadFloorFaceSta(FaceDataContent var1, Long var2, String var3, BoundHashOperations var4);

    abstract void loadZoneFaceSta(FaceDataContent var1, Long var2, String var3, BoundHashOperations var4);

    abstract String getDateStr(Date var1);
}

