/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.stream;

import com.viontech.keliu.batch.item.stream.ItemValidStream;
import com.viontech.keliu.model.MallOpentime;
import com.viontech.keliu.util.DateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BussinessValidItemStream<T>
implements ItemValidStream<T> {
    private Logger logger = LoggerFactory.getLogger(BussinessValidItemStream.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final String SQL_SEL_OPENTIME = "select mall_id,account_id,start_time,end_time,start_date,end_date,type from b_mall_opentime";
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();

    public boolean isValid(T item) {
        Date endTime;
        Map openTimeMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("openTimeMap");
        MallOpentime mallopenTime = (MallOpentime)openTimeMap.get(this.getMallId(item));
        if (mallopenTime == null) {
            return true;
        }
        Date startTime = mallopenTime.getStartTime();
        if (startTime.equals(endTime = mallopenTime.getEndTime())) {
            return true;
        }
        if (BussinessValidItemStream.isInBusiness((Date)this.getCounttime(item), (Date)startTime, (Date)endTime)) {
            return true;
        }
        this.logger.debug(this.getMallId(item) + "\t\u8425\u4e1a\u65f6\u95f4\u8303\u56f4\u5916\u6570\u636e-\u8df3\u8fc7,mallId:" + this.getMallId(item) + "\u7edf\u8ba1\u65f6\u95f4:" + DateUtil.format((String)DateUtil.FORMAT_YYYY_MM_DD_HH_MM, (Date)this.getCounttime(item)));
        return false;
    }

    public static boolean isInBusiness(Date counttime, Date startTime, Date endTime) {
        Calendar counttimeCalendar = Calendar.getInstance();
        counttimeCalendar.setTime(counttime);
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(startTime);
        int counttimeHour = counttimeCalendar.get(11);
        int counttimeMinute = counttimeCalendar.get(12);
        int startTimeHour = startTimeCalendar.get(11);
        int startTimeMinute = startTimeCalendar.get(12);
        if (startTime.before(endTime)) {
            if (counttimeHour < startTimeHour) {
                return false;
            }
            if (counttimeHour == startTimeHour && counttimeMinute < startTimeMinute) {
                return false;
            }
            Calendar endTimeCalendar = Calendar.getInstance();
            endTimeCalendar.setTime(endTime);
            int endTimeHour = endTimeCalendar.get(11);
            int endTimeMinute = endTimeCalendar.get(12);
            if (counttimeHour > endTimeHour) {
                return false;
            }
            return counttimeHour != endTimeHour || counttimeMinute <= endTimeMinute;
        }
        Calendar endTimeCalendar = Calendar.getInstance();
        endTimeCalendar.setTime(endTime);
        int endTimeHour = endTimeCalendar.get(11);
        int endTimeMinute = endTimeCalendar.get(12);
        if (counttimeHour > startTimeHour) {
            return true;
        }
        if (counttimeHour == startTimeHour && counttimeMinute > startTimeMinute) {
            return true;
        }
        if (counttimeHour < endTimeHour) {
            return true;
        }
        return counttimeHour == endTimeHour && counttimeMinute < endTimeMinute;
    }

    private void updateOpenTime(ExecutionContext executionContext) {
        List mallOpentimes = this.jdbcTemplate.query("select mall_id,account_id,start_time,end_time,start_date,end_date,type from b_mall_opentime", (RowMapper)new BeanPropertyRowMapper(MallOpentime.class));
        HashMap opentimeMap = new HashMap();
        mallOpentimes.forEach(item -> opentimeMap.put(item.getMallId(), item));
        executionContext.put("openTimeMap", opentimeMap);
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        this.updateOpenTime(executionContext);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        this.updateOpenTime(executionContext);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("openTimeMap");
        this.executionContextThreadLocal.remove();
    }

    protected abstract Date getCounttime(T var1);

    protected abstract Long getMallId(T var1);
}

