/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.reader;

import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamReader;

public abstract class ConcurrencyReader<T>
implements ItemStreamReader<T> {
    ThreadLocal<ItemStreamReader<T>> readerThreadLocal = new ThreadLocal();

    public T read() throws Exception {
        ItemStreamReader reader = (ItemStreamReader)this.readerThreadLocal.get();
        if (reader == null) {
            reader = this.buildReader();
            this.readerThreadLocal.set(reader);
        }
        return (T)reader.read();
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        ItemStreamReader reader = (ItemStreamReader)this.readerThreadLocal.get();
        if (reader == null) {
            reader = this.buildReader();
            this.readerThreadLocal.set(reader);
        }
        reader.open(executionContext);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        ItemStreamReader reader = (ItemStreamReader)this.readerThreadLocal.get();
        if (reader == null) {
            reader = this.buildReader();
            this.readerThreadLocal.set(reader);
        }
        reader.update(executionContext);
    }

    public void close() throws ItemStreamException {
        ItemStreamReader reader = (ItemStreamReader)this.readerThreadLocal.get();
        if (reader == null) {
            reader = this.buildReader();
            this.readerThreadLocal.set(reader);
        }
        reader.close();
    }

    public abstract ItemStreamReader<T> buildReader();
}

