/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.model.ZoneCountData;
import com.viontech.keliu.util.DateUtil;
import java.util.Date;
import java.util.Map;
import org.springframework.batch.item.ItemProcessor;

public class ZoneCountDataProcessor
implements ItemProcessor<Map, ZoneCountData> {
    private int mallDayTimeOffset;

    public ZoneCountDataProcessor(int mallDayTimeOffset) {
        this.mallDayTimeOffset = mallDayTimeOffset;
    }

    public ZoneCountData process(Map item) throws Exception {
        String updateNumStr = (String)item.get("flagUpdate");
        Long updateNum = updateNumStr == null ? null : Long.valueOf(updateNumStr);
        Long writeNum = (Long)item.get("flagWrite");
        if (updateNum != null && writeNum != null && writeNum.equals(updateNum)) {
            return null;
        }
        if (updateNum != null && writeNum == null) {
            writeNum = updateNum;
        }
        String redisKey = (String)item.get("redisKey");
        Long zoneId = (Long)item.get("zoneId");
        if (zoneId == null) {
            return null;
        }
        Long floorId = (Long)item.get("floorId");
        if (floorId == null) {
            return null;
        }
        Long mallId = (Long)item.get("mallId");
        if (mallId == null) {
            return null;
        }
        Long accountId = (Long)item.get("accountId");
        if (accountId == null) {
            return null;
        }
        Integer innum = 0;
        try {
            innum = Integer.parseInt(item.get("innum").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer outnum = 0;
        try {
            outnum = Integer.parseInt(item.get("outnum").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer outsideInnum = 0;
        try {
            outsideInnum = Integer.parseInt(item.get("outsideInum").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer outsideOutnum = 0;
        try {
            outsideOutnum = Integer.parseInt(item.get("outsideOutnum").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date createTime = (Date)item.get("createTime");
        if (createTime == null) {
            return null;
        }
        ZoneCountData zoneCountData = new ZoneCountData();
        zoneCountData.setInnum(innum.intValue());
        zoneCountData.setOutnum(outnum.intValue());
        zoneCountData.setOutsideInnum(outsideInnum.intValue());
        zoneCountData.setOutsideOutnum(outsideOutnum.intValue());
        zoneCountData.setAccountId(accountId.longValue());
        zoneCountData.setMallId(mallId.longValue());
        zoneCountData.setFloorId(floorId.longValue());
        zoneCountData.setZoneId(zoneId.longValue());
        zoneCountData.setCountDate(DateUtil.addHours((Date)createTime, (int)this.mallDayTimeOffset));
        zoneCountData.setCountTime(createTime);
        zoneCountData.setRedisKey(redisKey);
        zoneCountData.setUpdateFlagNum(updateNum);
        zoneCountData.setWriteFlagNum(writeNum);
        return zoneCountData;
    }
}

