/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.model.ConfigParam;
import com.viontech.keliu.model.MatchParam;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.service.ConfigParamService;
import com.viontech.keliu.service.StaffMatchService;
import com.viontech.keliu.util.ConfigUtil;
import com.viontech.keliu.websocket.AlgApiClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="staffRecognitionProcessor")
public class StaffRecognitionProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private final Logger logger = LoggerFactory.getLogger(StaffRecognitionProcessor.class);
    @Autowired(required=false)
    private AlgApiClient algApiClientComparison;
    @Value(value="${match.score.staff:78}")
    private Integer matchScoreStaff;
    @Value(value="${match.score.staffBody:78}")
    private Integer matchScoreStaffBody;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();
    @Resource
    private ConfigParamService configParamService;
    @Autowired
    private StaffMatchService staffMatchService;

    public FaceDataContent process(FaceDataContent item) throws Exception {
        if (this.algApiClientComparison == null) {
            return item;
        }
        if (item.getMallId() == null) {
            this.logger.debug("\u8be5\u6761\u4eba\u8138\u6570\u636e\u7684mallId\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5e97\u5458\u6bd4\u5bf9\u529f\u80fd\uff01");
            return item;
        }
        if (item.getPerson() == null) {
            return item;
        }
        Map configParamMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("configMap");
        ConfigParam configParam = ConfigUtil.getConfigParam((Long)item.getMallId(), (Map)configParamMap);
        String staff = configParam.getStaff();
        if ("0".equals(staff)) {
            this.logger.debug("\u5546\u573aid\u4e3a{}\u7684\u5546\u573a\u5173\u95ed\u5e97\u5458\u6bd4\u5bf9\u529f\u80fd,\u8df3\u8fc7\u5e97\u5458\u6bd4\u5bf9\u5904\u7406", (Object)item.getMallId());
            return item;
        }
        this.logger.debug("\u5546\u573aid\u4e3a{}\u7684\u5546\u573a\u5f00\u542f\u5e97\u5458\u6bd4\u5bf9\u529f\u80fd,value\u4e3a{}", (Object)item.getMallId(), (Object)configParam.getStaff());
        try {
            List matchResult;
            MatchParam matchParam = new MatchParam();
            matchParam.setMatchThreshold(this.matchScoreStaff.intValue());
            matchParam.setAppend(false);
            ArrayList<Date> dates = new ArrayList<Date>();
            dates.add(item.getCountDate());
            matchParam.setDates(dates);
            matchParam.setMallId(item.getMallId());
            if ("1".equals(configParam.getStaffBodyMatch())) {
                matchParam.setMatchBody(true);
                matchParam.setMatchBodyThreshold(this.matchScoreStaffBody.intValue());
            }
            if ((matchResult = this.staffMatchService.match(item.getPerson(), matchParam)) != null && matchResult.size() > 0) {
                String personUnid = ((Person)matchResult.get(0)).getPersonId();
                this.logger.info("\u5b8c\u6210\u5e97\u5458\u5339\u914d,\u5339\u914d\u7ed3\u679c:{}", (Object)personUnid);
                item.setPersonId(personUnid);
                item.setPersonType(Integer.valueOf(1));
            }
        }
        catch (Exception e) {
            this.logger.error("\u5e97\u5458\u5339\u914d\u5931\u8d25", (Throwable)e);
        }
        return item;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("configMap");
        this.executionContextThreadLocal.remove();
    }
}

