/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.exception.ParameterExceptin;
import com.viontech.keliu.model.BodyFeature;
import com.viontech.keliu.model.ConfigParam;
import com.viontech.keliu.model.Data;
import com.viontech.keliu.model.Feature;
import com.viontech.keliu.model.Mall;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.service.ConfigParamService;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.util.ConfigUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.websocket.AlgApiClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.websocket.DeploymentException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="reidDataProcessor")
public class ReidDataProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    @Value(value="${ws.url:}")
    private String url;
    @Value(value="${spring.application.name}")
    private String applicationName;
    private final Logger logger = LoggerFactory.getLogger(ReidDataProcessor.class);
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();
    @Autowired(required=false)
    private AlgApiClient algApiClientComparison;
    @Autowired
    private ObjectMapper objectMapper;
    @Resource
    private Storage featureStorage;
    @Resource
    private OrgCacheService orgCacheService;
    @Resource
    private ConfigParamService configParamService;

    public FaceDataContent process(FaceDataContent item) throws Exception {
        if (item.getMallId() == null) {
            this.logger.debug("\u8be5\u6761\u4eba\u8138\u6570\u636e\u7684mallId\u4e3a\u7a7a\uff0c\u8df3\u8fc7reid\u5904\u7406\uff01");
            return item;
        }
        Map configParamMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("configMap");
        ConfigParam configParam = ConfigUtil.getConfigParam((Long)item.getMallId(), (Map)configParamMap);
        String reid = configParam.getReid();
        if ("0".equals(reid)) {
            this.logger.debug("\u5546\u573aid\u4e3a{}\u7684\u5546\u573a\u5173\u95edreid\u529f\u80fd,\u8df3\u8fc7reid\u5904\u7406", (Object)item.getMallId());
            return item;
        }
        this.logger.debug("\u5546\u573aid\u4e3a{}\u7684\u5546\u573a\u5f00\u542freid\u529f\u80fd,value\u4e3a{}", (Object)item.getMallId(), (Object)configParam.getReid());
        long start = System.currentTimeMillis();
        Map gate2MallMap = this.orgCacheService.getGate2MallMap();
        if (this.isNullOrStaffOrAcrossOrNotMallGate(item, gate2MallMap)) {
            Long gateId = item.getGateId();
            Object obj = gate2MallMap.get(String.valueOf(gateId));
            this.logger.warn("reid-\u4e0d\u9700\u8981\u5904\u7406personType:{},direction:{},gate2MallMap:{},gateid:{}", new Object[]{item.getPersonType(), item.getDirection(), obj, gateId});
            return item;
        }
        this.logger.info("reid-\u6536\u5230\u5904\u7406\u6d88\u606f,gateid:{}", (Object)item.getGateId());
        if (this.isEnter(item)) {
            item.setNeedInsert(1);
            item.setArrivalUnid(item.getUnid());
            item.setArrivalTime(item.getCountDate());
            if (this.addToPersonPoolSuccessfully(item)) {
                return item;
            }
            this.logger.error("\u628a\u4eba\u6254\u8fdb\u6c60\u5b50\u91cc\u5931\u8d25!!!!\u5566------{}", (Object)item.getUnid());
        } else if (this.isLeave(item)) {
            item.setLeaveTime(item.getCountDate());
            JSONObject object = this.getArrivalTime(item);
            if (object == null || object.getInt("success") != 1) {
                item.setNeedInsert(0);
                return item;
            }
            item.setArrivalTime(DateUtil.parse((String)DateUtil.FORMAT_LONG, (String)object.getString("inTime")));
            item.setArrivalUnid(object.getString("personId"));
            long residenceDuration = (item.getLeaveTime().getTime() - item.getArrivalTime().getTime()) / 1000L;
            item.setResidenceTime(Integer.valueOf((int)residenceDuration));
            this.logger.info("\u6ede\u7559\u65f6\u95f4----------" + residenceDuration);
            if (this.isRealData(object)) {
                item.setNeedInsert(2);
                item.setArrivalUnid(item.getArrivalUnid());
                if (!this.deleteFromPersonPoolSuccessfully(item)) {
                    this.logger.error("\u4ece\u6c60\u5b50\u91cc\u6d88\u706d\u4eba\u7c7b\u5931\u8d25!!!!\u5566----------{}", (Object)item.getArrivalUnid());
                }
            } else {
                item.setNeedInsert(1);
            }
        }
        long end = System.currentTimeMillis();
        this.logger.debug("Reid\u5904\u7406\u8017\u65f6\uff1a" + (end - start));
        return item;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.logger.info("\u5f00\u59cb\u6267\u884cReidDataProcessor>>>>>>>>>>>>>>>>");
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("configMap");
        this.executionContextThreadLocal.remove();
        this.logger.info("-------ReidDataProcessor\u5173\u95ed-------");
    }

    private boolean isNullOrStaffOrAcrossOrNotMallGate(FaceDataContent item, Map gate2MallMap) {
        return item.getPersonType() == null || item.getPersonType() == 1 || item.getDirection() == 0 || gate2MallMap.get(String.valueOf(item.getGateId())) == null;
    }

    private boolean isRealData(JSONObject object) {
        boolean real = object.getInt("reality") == 1;
        this.logger.info("\u6570\u636e\u662f\u5426\u771f\u5b9e\uff01\uff01\uff01\uff01" + real);
        return real;
    }

    private boolean isEnter(FaceDataContent item) {
        return item.getDirection() == 1;
    }

    private boolean isLeave(FaceDataContent item) {
        return item.getDirection() == -1;
    }

    private boolean addToPersonPoolSuccessfully(FaceDataContent item) throws DeploymentException, IOException, ParameterExceptin {
        Person person = new Person();
        person.setPersonId(item.getUnid());
        person.setBodyFeatures(this.getBodyFeatures(item));
        person.setInTime(DateUtil.format((String)DateUtil.FORMAT_LONG, (Date)item.getCountDate()));
        person.setAge(Integer.valueOf(item.getAge()));
        person.setGender(item.getGender() == 0 ? "female" : "male");
        ArrayList<Person> persons = new ArrayList<Person>();
        persons.add(person);
        return this.modifyPersonPool(item, persons) || this.addPersonPool(item, persons);
    }

    private boolean deleteFromPersonPoolSuccessfully(FaceDataContent item) {
        Person person = new Person();
        person.setPersonId(item.getArrivalUnid());
        ArrayList<Person> persons = new ArrayList<Person>();
        persons.add(person);
        try {
            CompletableFuture responseFuture = this.algApiClientComparison.delPersonPool(0, this.getPoolId(item), persons, new HashMap());
            JSONObject response = (JSONObject)responseFuture.get(120L, TimeUnit.SECONDS);
            if (response.getInt("success") == 1) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private JSONObject getArrivalTime(FaceDataContent item) {
        List bodyFeatures = this.getBodyFeatures(item);
        if (bodyFeatures.size() <= 0) {
            this.logger.error("\u672a\u627e\u5230\u7279\u5f81\u6587\u4ef6--------------------");
            return null;
        }
        try {
            CompletableFuture responseFuture = this.algApiClientComparison.getInTime(bodyFeatures, DateUtil.format((String)"yyyy-MM-dd HH:mm:ss", (Date)item.getCountDate()), this.getPoolId(item), new ArrayList(), new HashMap());
            return (JSONObject)responseFuture.get(120L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<BodyFeature> getBodyFeatures(FaceDataContent item) {
        String bodyPic = item.getBodyPicExt();
        bodyPic = bodyPic.replaceAll("[\\[\\]]", "");
        bodyPic = bodyPic.replaceAll(" ", "");
        String[] bodyPics = bodyPic.split(",");
        ArrayList<BodyFeature> bodyFeatures = new ArrayList<BodyFeature>();
        for (String bodyName : bodyPics) {
            List data;
            bodyName = bodyName.trim();
            String json = (String)this.featureStorage.getItem(item.getChannelSerialnum() + "/" + bodyName);
            Feature feature = this.json2Feature(json);
            if (feature == null || (data = feature.getDatas()) == null || data.size() <= 0) continue;
            for (Data datum : data) {
                if ("camera".equals(datum.getType())) continue;
                BodyFeature bodyFeature = new BodyFeature();
                bodyFeature.setFeature(datum.getData());
                bodyFeature.setBid(bodyName + ".feature");
                bodyFeatures.add(bodyFeature);
            }
        }
        return bodyFeatures;
    }

    private Feature json2Feature(String json) {
        Feature feature = null;
        if (json == null) {
            return null;
        }
        try {
            feature = (Feature)this.objectMapper.readValue(json, Feature.class);
        }
        catch (Exception e) {
            this.logger.error("\u65e0\u6cd5\u5c06json\u8f6c\u6210\u7279\u5f81\u5bf9\u8c61:" + json);
            e.printStackTrace();
        }
        return feature;
    }

    private boolean modifyPersonPool(FaceDataContent item, List<Person> persons) {
        try {
            CompletableFuture responseFuture = this.algApiClientComparison.modifyPersonPool(this.getPoolId(item), 2, 2, persons, new HashMap());
            JSONObject response = (JSONObject)responseFuture.get(120L, TimeUnit.SECONDS);
            return response.getInt("success") == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean addPersonPool(FaceDataContent item, List<Person> persons) {
        try {
            CompletableFuture responseFuture = this.algApiClientComparison.addPersonPool(this.getPoolId(item), 2, persons, new HashMap());
            return ((JSONObject)responseFuture.get(120L, TimeUnit.SECONDS)).getInt("success") == 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String getPoolId(FaceDataContent item) {
        Map mallMap = this.orgCacheService.getMallMap();
        String format = DateUtil.format((String)DateUtil.FORMAT_SHORT, (Date)item.getCountDate());
        Mall mall = (Mall)mallMap.get(item.getMallId().toString());
        String poolName = this.applicationName + "_residencePool_" + format + "_";
        poolName = mall != null ? poolName + mall.getUnid() : poolName + item.getMallId();
        return poolName;
    }
}

