/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.content.CountDataContent;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component(value="rawCountDataProcessor")
public class RawCountDataProcessor
implements ItemProcessor<CountDataContent, CountDataContent>,
ItemStream {
    private Logger logger = LoggerFactory.getLogger(RawCountDataProcessor.class);
    @Resource
    private OrgCacheService orgCacheService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final Object countDataRawKeySync = new Object();

    public CountDataContent process(CountDataContent item) throws Exception {
        Map channelMap = this.orgCacheService.getChannelMap();
        Channel channel = (Channel)channelMap.get(item.getChannelno());
        if (channel == null) {
            this.logger.warn("\u65e0\u6cd5\u67e5\u627e\u901a\u9053 \u8df3\u8fc7\u6570\u636e" + item.getChannelno());
            return null;
        }
        if (item.getCreateTime() == null) {
            this.logger.warn("CountData\u6570\u636e\u6ca1\u6709\u7edf\u8ba1\u65f6\u95f4");
            return null;
        }
        item.setGateId(channel.getGateId());
        item.setRepeat(false);
        if (this.isRepeat(item)) {
            this.logger.warn("\u91cd\u590dCountData\u6570\u636e");
            item.setRepeat(true);
            List countDataContentList = this.jdbcTemplate.query("select innum,outnum from d_count_data where channel_serialnum = ? and counttime = ? and  countdate = ? and status = 0", new Object[]{item.getChannelno(), item.getCountdate(), item.getCountdate()}, (RowMapper)new BeanPropertyRowMapper(CountDataContent.class));
            if (countDataContentList.isEmpty()) {
                this.logger.warn("\u672c\u6b21\u4e0a\u4f20\u7684\u91cd\u590d\u6570\u636e");
                return null;
            }
            Integer innumDiff = item.getInnum() - ((CountDataContent)countDataContentList.get(0)).getInnum();
            Integer outnumDiff = item.getOutnum() - ((CountDataContent)countDataContentList.get(0)).getOutnum();
            if (innumDiff == 0 && outnumDiff == 0) {
                this.logger.warn("\u503c\u76f8\u540c\u7684\u91cd\u590d\u6570\u636e");
                return null;
            }
            item.setInnum(innumDiff.intValue());
            item.setOutnum(outnumDiff.intValue());
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRepeat(CountDataContent item) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date counttime = item.getCreateTime();
        StringBuilder sb = new StringBuilder();
        sb.append(item.getChannelno());
        sb.append(":");
        sb.append(sdf.format(counttime));
        String key = sb.toString();
        String datestr = DateUtil.format((String)"yyyyMMdd", (Date)item.getCountdate());
        String countDataRawKey = "countDataRawKey:" + datestr;
        if (!this.redisTemplate.expire((Object)countDataRawKey, 2L, TimeUnit.HOURS).booleanValue()) {
            Object object = countDataRawKeySync;
            synchronized (object) {
                if (!this.redisTemplate.hasKey((Object)countDataRawKey).booleanValue()) {
                    List countDataContentList = this.jdbcTemplate.query("select channel_serialnum as channelno,counttime as createTime from d_count_data where  countdate = ?", new Object[]{item.getCountdate()}, (RowMapper)new BeanPropertyRowMapper(CountDataContent.class));
                    if (countDataContentList.isEmpty()) {
                        this.redisTemplate.boundSetOps((Object)countDataRawKey).add(new Object[]{key});
                        return false;
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    for (CountDataContent countDataContent : countDataContentList) {
                        if (countDataContent.getChannelno() == null && countDataContent.getCreateTime() == null) continue;
                        list.add(countDataContent.getChannelno() + ":" + sdf.format(countDataContent.getCreateTime()));
                    }
                    this.redisTemplate.execute((SessionCallback)new /* Unavailable Anonymous Inner Class!! */);
                    this.redisTemplate.expire((Object)countDataRawKey, 2L, TimeUnit.HOURS);
                }
            }
        }
        return this.redisTemplate.boundSetOps((Object)countDataRawKey).add(new Object[]{key}) <= 0L;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void close() throws ItemStreamException {
    }
}

