/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.content.FaceDataContent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class PicIsReadyProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private final Logger logger = LoggerFactory.getLogger(PicIsReadyProcessor.class);
    @Resource
    private RedisTemplate redisTemplate;
    private ThreadLocal<SimpleDateFormat> sdfThreadLocal = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd"));

    public FaceDataContent process(FaceDataContent item) throws Exception {
        String[] bodyImageName;
        this.logger.info("{} \u539f\u59cb\u6570\u636e\u5f00\u59cb\u5904\u7406", (Object)item.getPersonId());
        ArrayList<String> pictures = new ArrayList<String>();
        String[] faceImageName = item.getFaceImageName();
        if (faceImageName != null) {
            for (String facePic : faceImageName) {
                if (facePic == null || facePic.trim().isEmpty()) continue;
                pictures.add(item.getChannelSerialnum() + "/" + facePic);
            }
        }
        if ((bodyImageName = item.getBodyImageName()) != null) {
            for (String bodyPic : bodyImageName) {
                if (bodyPic == null || bodyPic.trim().isEmpty()) continue;
                pictures.add(item.getChannelSerialnum() + "/" + bodyPic);
            }
        }
        Date date = item.getCountDate();
        String dateStr = ((SimpleDateFormat)this.sdfThreadLocal.get()).format(date);
        String key = "recognitionPictures:" + dateStr;
        BoundSetOperations boundSetOperations = this.redisTemplate.boundSetOps((Object)key);
        for (String picture : pictures) {
            boolean isExist;
            if (picture == null || (isExist = boundSetOperations.isMember((Object)picture).booleanValue())) continue;
            if (System.currentTimeMillis() - item.getCountDate().getTime() > 600000L) {
                this.logger.info("\u56fe\u7247\u957f\u65f6\u95f4\u4e0d\u4e0a\u4f20\uff0c\u76f4\u63a5\u5904\u7406\u6389{}", (Object)picture);
                break;
            }
            this.redisTemplate.boundListOps((Object)"faceData").leftPush((Object)item);
            return null;
        }
        this.logger.info("{} \u539f\u59cb\u6570\u636e\u6b63\u5f0f\u5904\u7406", (Object)item.getPersonId());
        if (item != null) {
            this.removePicFromRedis(boundSetOperations, pictures);
        }
        return item;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void close() throws ItemStreamException {
    }

    private void removePicFromRedis(BoundSetOperations boundSetOperations, List<String> pictures) {
        for (String picture : pictures) {
            boundSetOperations.remove(new Object[]{picture});
        }
    }
}

