/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.batch.item.processor.CustomRecognitionProcessor;
import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.dao.DbPersonDao;
import com.viontech.keliu.model.ConfigParam;
import com.viontech.keliu.model.MatchParam;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.service.ConfigParamService;
import com.viontech.keliu.service.DbPersonMatchService;
import com.viontech.keliu.util.ConfigUtil;
import com.viontech.keliu.websocket.AlgApiClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="personRecognitionProcessor")
public class PersonRecognitionProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private final Logger logger = LoggerFactory.getLogger(CustomRecognitionProcessor.class);
    @Autowired(required=false)
    private AlgApiClient algApiClientComparison;
    @Value(value="${match.score.prson:78}")
    private Integer matchScorePerson;
    @Autowired
    private ConfigParamService configParamService;
    @Autowired
    private DbPersonMatchService dbPersonMatchService;
    @Autowired
    private DbPersonDao dbPersonDao;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();
    private static final AtomicBoolean flag = new AtomicBoolean();

    public PersonRecognitionProcessor() {
        this.logger.info("\u521b\u5efaPersonRecognitionProcessor");
    }

    public FaceDataContent process(FaceDataContent item) throws Exception {
        this.logger.info("\u5f00\u59cb\u5904\u7406\u4eba\u5458\u6bd4\u5bf9");
        try {
            if (this.algApiClientComparison == null) {
                this.logger.info("\u6bd4\u5bf9\u670d\u52a1\u5668\u4e3anull\uff0c\u8df3\u8fc7\u4eba\u5458\u6bd4\u5bf9\u529f\u80fd\uff01");
                return item;
            }
            if (item.getPerson() == null) {
                this.logger.info("\u627e\u4e0d\u5230\u9700\u8981\u6bd4\u5bf9\u7684\u4eba\uff0c\u8df3\u8fc7\u4eba\u5458\u6bd4\u5bf9\u529f\u80fd\uff01");
                return item;
            }
            if (item.getMallId() == null) {
                this.logger.info("\u8be5\u6761\u4eba\u8138\u6570\u636e\u7684mallId\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u4eba\u5458\u6bd4\u5bf9\u529f\u80fd\uff01");
                return item;
            }
            Integer personType = item.getPersonType();
            if (personType != null && personType != 0) {
                this.logger.info("\u7c7b\u578b\u5df2\u7ecf\u786e\u5b9a\uff0c\u8df3\u8fc7\u4eba\u5458\u6bd4\u5bf9\u529f\u80fd\uff01");
                return item;
            }
            item.setPersonType(Integer.valueOf(0));
            Map configParamMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("configMap");
            ConfigParam configParam = ConfigUtil.getConfigParam((Long)item.getMallId(), (Map)configParamMap);
            String personLib = configParam.getPersonLib();
            if ("0".equals(personLib)) {
                this.logger.info("\u7c7b\u578b\u5df2\u7ecf\u786e\u5b9a\uff0c\u8df3\u8fc7\u4eba\u5458\u6bd4\u5bf9\u529f\u80fd\uff01");
                return item;
            }
            MatchParam matchParam = new MatchParam();
            matchParam.setMallId(item.getMallId());
            matchParam.setAppend(false);
            matchParam.setFaceScore(item.getFace_score());
            matchParam.setMatchThreshold(this.matchScorePerson.intValue());
            matchParam.setSubPool(configParam.getSubPool() == null ? true : "1".equals(configParam.getSubPool()));
            List matchResult = this.dbPersonMatchService.match(item.getPerson(), matchParam);
            if (matchResult != null && matchResult.size() > 0) {
                String personUnid = ((Person)matchResult.get(0)).getPersonId();
                item.setPersonId(personUnid);
                item.setPersonType(this.dbPersonDao.selTypeByUnid(item.getMallId(), personUnid));
            }
        }
        catch (Exception e) {
            this.logger.error("\u4eba\u5458\u5e93\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
        return item;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("configMap");
        this.executionContextThreadLocal.remove();
    }

    public static void main(String[] args) {
        boolean a = flag.compareAndSet(false, true);
        System.out.println(a);
        boolean b = flag.compareAndSet(false, true);
        System.out.println(b);
        boolean c = flag.compareAndSet(true, false);
        System.out.println(c);
    }
}

