/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.model.MallCountData;
import com.viontech.keliu.util.DateUtil;
import java.util.Date;
import java.util.Map;
import org.springframework.batch.item.ItemProcessor;

public class MallCountDataProcessor
implements ItemProcessor<Map, MallCountData> {
    private int mallDayTimeOffset;

    public MallCountDataProcessor(int mallDayTimeOffset) {
        this.mallDayTimeOffset = mallDayTimeOffset;
    }

    public MallCountData process(Map item) throws Exception {
        String updateNumStr = (String)item.get("flagUpdate");
        Long updateNum = updateNumStr == null ? null : Long.valueOf(updateNumStr);
        Long writeNum = (Long)item.get("flagWrite");
        if (updateNum != null && writeNum != null && writeNum.equals(updateNum)) {
            return null;
        }
        if (updateNum != null && writeNum == null) {
            writeNum = updateNum;
        }
        String redisKey = (String)item.get("redisKey");
        Long mallId = (Long)item.get("mallId");
        if (mallId == null) {
            return null;
        }
        Long accountId = (Long)item.get("accountId");
        if (accountId == null) {
            return null;
        }
        Integer innum = 0;
        try {
            innum = Integer.parseInt(item.get("innum").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer outnum = 0;
        try {
            outnum = Integer.parseInt(item.get("outnum").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer outsideInnum = 0;
        try {
            outsideInnum = Integer.parseInt(item.get("outsideInum").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer outsideOutnum = 0;
        try {
            outsideOutnum = Integer.parseInt(item.get("outsideOutnum").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date createTime = (Date)item.get("createTime");
        if (createTime == null) {
            return null;
        }
        MallCountData mallCountData = new MallCountData();
        mallCountData.setInnum(innum.intValue());
        mallCountData.setOutnum(outnum.intValue());
        mallCountData.setAccountId(accountId.longValue());
        mallCountData.setMallId(mallId.longValue());
        mallCountData.setCountDate(DateUtil.addHours((Date)createTime, (int)this.mallDayTimeOffset));
        mallCountData.setCountTime(createTime);
        mallCountData.setOutsideInnum(outsideInnum.intValue());
        mallCountData.setOutsideOutnum(outsideOutnum.intValue());
        mallCountData.setRedisKey(redisKey);
        mallCountData.setUpdateFlagNum(updateNum);
        mallCountData.setWriteFlagNum(writeNum);
        return mallCountData;
    }
}

