/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.Retention;
import com.viontech.keliu.service.OrgCacheService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="gateRetentionDataProcessor")
public class GateRetentionDataProcessor
implements ItemProcessor<Retention, Retention>,
ItemStream {
    @Autowired
    private OrgCacheService orgCacheService;
    private Logger logger = LoggerFactory.getLogger(GateRetentionDataProcessor.class);

    public Retention process(Retention item) throws Exception {
        this.logger.debug("\u5f00\u59cb\u76d1\u63a7\u70b9\u5ba2\u6d41\u662f\u5426\u9700\u8981\u7d2f\u52a0\u5224\u65ad");
        if (item.getCounttime() == null) {
            this.logger.warn("CountData\u6570\u636e\u6ca1\u6709\u7edf\u8ba1\u65f6\u95f4");
            return null;
        }
        if (item.getGateId() == null) {
            Map channelMap = this.orgCacheService.getChannelMap();
            Channel channel = (Channel)channelMap.get(item.getChannelSerialnum());
            if (channel == null) {
                this.logger.warn("\u65e0\u6cd5\u67e5\u627e\u901a\u9053 \u8df3\u8fc7\u6570\u636e" + item.getChannelSerialnum());
                return null;
            }
            item.setGateId(channel.getGateId());
        }
        if (item.getGateId() == null) {
            return null;
        }
        return item;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void close() throws ItemStreamException {
    }
}

