/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.model.BodyFeature;
import com.viontech.keliu.model.ConfigParam;
import com.viontech.keliu.model.Data;
import com.viontech.keliu.model.FaceFeature;
import com.viontech.keliu.model.Feature;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.model.Result;
import com.viontech.keliu.service.ConfigParamService;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.util.ConfigUtil;
import com.viontech.keliu.websocket.AlgApiClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.tomcat.util.codec.binary.Base64;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="featureExtractProcessor")
public class FeatureExtractProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private final Logger logger = LoggerFactory.getLogger(FeatureExtractProcessor.class);
    @Resource
    private Storage imageStorage;
    @Resource
    private Storage featureStorage;
    @Resource
    private ConfigParamService configParamService;
    @Value(value="${ws.featureUrl:}")
    private String url;
    @Autowired(required=false)
    private AlgApiClient algApiClientFeature;
    @Autowired
    private ObjectMapper objectMapper;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();

    public FaceDataContent process(FaceDataContent item) throws Exception {
        if (this.algApiClientFeature == null) {
            return item;
        }
        this.extractFaceFeature(this.getNeedExtractPics(item, true), item);
        this.extractBodyFeature(this.getNeedExtractPics(item, false), item);
        return item;
    }

    private String transformFeatureConfig(String featureConfig, boolean isNotNone) {
        switch (featureConfig) {
            case "0": {
                if (isNotNone) {
                    return "all";
                }
                return "none";
            }
            case "1": {
                return "one";
            }
            case "2": {
                return "all";
            }
        }
        return featureConfig;
    }

    private List<String> getNeedExtractPics(FaceDataContent item, boolean face) {
        String[] imageName;
        boolean isNotNone;
        String featureConfig;
        ArrayList<String> pictures = new ArrayList<String>();
        Map configParamMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("configMap");
        ConfigParam configParam = ConfigUtil.getConfigParam((Long)item.getMallId(), (Map)configParamMap);
        if (face) {
            featureConfig = configParam.getFaceFeature();
            isNotNone = "1".equals(configParam.getCalibrate()) || "1".equals(configParam.getCustom()) || "1".equals(configParam.getStaff()) || "1".equals(configParam.getNewOrRegular());
            imageName = item.getFaceImageName();
        } else {
            featureConfig = configParam.getBodyFeature();
            isNotNone = "1".equals(configParam.getReid());
            imageName = item.getBodyImageName();
        }
        featureConfig = this.transformFeatureConfig(featureConfig, isNotNone);
        if (!"none".equals(featureConfig)) {
            for (String image : imageName) {
                if (image == null || "".equals(image.trim()) || image.contains("null")) continue;
                pictures.add(image.trim());
                if ("one".equals(featureConfig)) break;
            }
        }
        return pictures;
    }

    private void extractFaceFeature(List<String> facePictures, FaceDataContent item) {
        if (facePictures.size() <= 0) {
            return;
        }
        ArrayList<String> images = new ArrayList<String>();
        ArrayList faceKeys = new ArrayList();
        for (String facePicture : facePictures) {
            List keyPoint = new ArrayList();
            try {
                String featureStr = (String)this.featureStorage.getItem(item.getChannelSerialnum() + "/" + facePicture);
                if (featureStr != null && !featureStr.trim().isEmpty()) {
                    Feature feature = (Feature)this.objectMapper.readValue(featureStr, Feature.class);
                    Integer faceType = feature.getFace_type();
                    if (item.getFace_score() == null || item.getFace_score().floatValue() < feature.getFace_score().floatValue()) {
                        item.setFace_score(feature.getFace_score());
                        item.setFace_type(faceType);
                    }
                    if (faceType != null && faceType != 1) {
                        this.logger.info("{} \u975e\u4eba\u8138\u7684\u7167\u7247\u8df3\u8fc7\u63d0\u53d6\u7279\u5f81,face_type:{}", (Object)facePicture, (Object)faceType);
                        continue;
                    }
                    keyPoint = feature.getKey_point();
                } else {
                    this.logger.warn("\u56fe\u7247 {} \u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7279\u5f81\u6587\u4ef6", (Object)facePicture);
                }
                byte[] byteArrayItem = this.imageStorage.getByteArrayItem(item.getChannelSerialnum() + "/" + facePicture);
                if (byteArrayItem == null) {
                    this.logger.warn("{} \u56fe\u7247\u4e0d\u5b58\u5728", (Object)facePicture);
                    continue;
                }
                String image = Base64.encodeBase64String((byte[])byteArrayItem);
                images.add(image);
                faceKeys.add(keyPoint);
            }
            catch (Exception e) {
                this.logger.info("\u4eba\u8138\u56fe\u7247" + facePicture + "\u5b58\u5728\u95ee\u9898", (Throwable)e);
            }
        }
        if (images.size() <= 0) {
            this.logger.warn("\u6ca1\u6709\u7b26\u5408\u7279\u5f81\u63d0\u53d6\u8981\u6c42\u7684\u4eba\u8138\u56fe\u7247,\u56fe\u7247\u6570\u91cf{}", (Object)facePictures.size());
            return;
        }
        this.logger.info("\u7b26\u5408\u7279\u5f81\u63d0\u53d6\u8981\u6c42\u7684\u4eba\u8138\u56fe\u7247\u6570\u91cf\u4e3a{}/{}", (Object)images.size(), (Object)facePictures.size());
        try {
            CompletableFuture responseFuture = this.algApiClientFeature.getFaceFeatureBatch(images, "jpg", faceKeys, Collections.emptyList());
            JSONObject response = (JSONObject)responseFuture.get(120L, TimeUnit.SECONDS);
            Result result = (Result)this.objectMapper.readValue(response.toString(), Result.class);
            List faceFeatureArr = result.getFaceFeatureArr();
            FaceFeature faceFeature = null;
            if (faceFeatureArr != null && faceFeatureArr.size() > 0) {
                faceFeature = (FaceFeature)faceFeatureArr.get(faceFeatureArr.size() - 1);
            }
            if (faceFeature == null || faceFeature.getFeature() == null || faceFeature.getFeature().length <= 0) {
                this.logger.warn("{} \u63d0\u53d6\u878d\u5408\u7279\u5f81\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u7279\u5f81,{}", (Object)item.getFacePic(), (Object)response.toString());
                return;
            }
            this.buidPerson(item, faceFeature, null);
            String facePic = item.getFacePic();
            String faceNameSubStr = facePic.substring(0, facePic.length() - 5);
            String faceNameF = faceNameSubStr + "F.jpg";
            Feature feature = new Feature();
            feature = this.buildFeature(feature, faceNameF, "face", item.getFace_score(), faceFeature.getFeature());
            String json = this.objectMapper.writeValueAsString((Object)feature);
            this.featureStorage.setItem(item.getChannelSerialnum() + "/" + faceNameF, (Object)json);
            this.logger.info("\u63d0\u53d6\u56fe\u7247 {} \u4eba\u8138\u7279\u5f81\u6210\u529f", (Object)faceNameF);
            item.setFaceFeature(faceNameF);
        }
        catch (Exception e) {
            this.logger.error(item.getFacePic() + "\u4eba\u8138\u7279\u5f81\u63d0\u53d6\u5931\u8d25", (Throwable)e);
        }
    }

    private void extractBodyFeature(List<String> bodyPictures, FaceDataContent item) {
        int successNum = 0;
        for (String bodyPicture : bodyPictures) {
            try {
                String featureStr = (String)this.featureStorage.getItem(item.getChannelSerialnum() + "/" + bodyPicture);
                if (featureStr == null || featureStr.trim().isEmpty()) {
                    this.logger.info("{}\u7684\u7279\u5f81\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u8005\u5185\u5bb9\u4e3aEmpty", (Object)bodyPicture);
                    continue;
                }
                Feature feature = (Feature)this.objectMapper.readValue(featureStr, Feature.class);
                if (feature == null) {
                    this.logger.info("{}\u7684\u7279\u5f81\u6587\u4ef6\u8f6c\u6362\u4e0d\u6210Feature model\u9519\u8bef", (Object)bodyPicture);
                    continue;
                }
                List dataInfo = feature.getDatas();
                Boolean haveServerFeature = false;
                if (dataInfo != null) {
                    for (Data data : dataInfo) {
                        if (!"server".equals(data.getType().trim())) continue;
                        haveServerFeature = true;
                    }
                }
                if (haveServerFeature.booleanValue()) continue;
                byte[] byteArrayItem = this.imageStorage.getByteArrayItem(item.getChannelSerialnum() + "/" + bodyPicture);
                if (byteArrayItem == null) {
                    this.logger.warn("{}\u4e0d\u5b58\u5728\u6216\u8005\u5185\u5bb9\u4e3a\u7a7a", (Object)bodyPicture);
                    continue;
                }
                String image = Base64.encodeBase64String((byte[])byteArrayItem);
                HashMap options = new HashMap();
                options.put("body_roi", feature.getBody_roi().get(0));
                CompletableFuture responseFuture = this.algApiClientFeature.getFeatureAndAttr(image, "body", "jpg", feature.getKey_point(), options);
                JSONObject response = (JSONObject)responseFuture.get(120L, TimeUnit.SECONDS);
                Result result = (Result)this.objectMapper.readValue(response.toString(), Result.class);
                if (result == null) {
                    this.logger.warn("\u56fe\u7247{}\u63d0\u53d6\u4eba\u4f53\u7279\u5f81\u5931\u8d25", (Object)bodyPicture);
                    continue;
                }
                BodyFeature bodyFeature = result.getBodyFeature();
                if (bodyFeature == null) {
                    this.logger.warn("\u56fe\u7247{}\u63d0\u53d6\u4eba\u4f53\u7279\u5f81\u5931\u8d25", (Object)bodyPicture);
                    continue;
                }
                Double[] featureArr = bodyFeature.getFeature();
                if (featureArr == null || featureArr.length <= 0) {
                    this.logger.warn("\u56fe\u7247{}\u63d0\u53d6\u4eba\u4f53\u7279\u5f81\u5931\u8d25", (Object)bodyPicture);
                    continue;
                }
                this.buidPerson(item, null, bodyFeature);
                feature = this.buildFeature(feature, feature.getFilename(), feature.getType(), feature.getFace_score(), featureArr);
                featureStr = this.objectMapper.writeValueAsString((Object)feature);
                this.featureStorage.setItem(item.getChannelSerialnum() + "/" + bodyPicture, (Object)featureStr);
                if (item.getBodyFeature() == null) {
                    item.setBodyFeature(bodyPicture);
                }
                ++successNum;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error(item.getBodyPic() + "\u4eba\u4f53\u7279\u5f81\u63d0\u53d6\u5931\u8d25", (Throwable)e);
            }
        }
        this.logger.info("\u63d0\u53d6\u56fe\u7247 {} \u4eba\u4f53\u7279\u5f81\u6210\u529f{}/{}", new Object[]{item.getBodyPic(), successNum, bodyPictures.size()});
    }

    private Feature buildFeature(Feature feature, String name, String type, Float faceScore, Double[] featureArr) {
        if (feature == null) {
            feature = new Feature();
        }
        feature.setFilename(name);
        feature.setType(type);
        feature.setFace_score(faceScore);
        feature.setFace_type(1);
        ArrayList<Data> datas = feature.getDatas();
        if (datas == null) {
            datas = new ArrayList<Data>();
            feature.setDatas(datas);
        }
        Data data = new Data();
        data.setType("server");
        data.setData(featureArr);
        datas.add(data);
        return feature;
    }

    private void buidPerson(FaceDataContent item, FaceFeature faceFeature, BodyFeature bodyFeature) {
        Person person = item.getPerson();
        if (person == null) {
            person = new Person();
            person.setPersonId(item.getPersonId());
            item.setPerson(person);
        }
        if (faceFeature != null) {
            ArrayList<FaceFeature> faceFeatures = person.getFaceFeatures();
            if (faceFeatures == null) {
                faceFeatures = new ArrayList<FaceFeature>();
                person.setFaceFeatures(faceFeatures);
            }
            faceFeatures.add(faceFeature);
        }
        if (bodyFeature != null) {
            ArrayList<BodyFeature> bodyFeatures = person.getBodyFeatures();
            if (bodyFeatures == null) {
                bodyFeatures = new ArrayList<BodyFeature>();
                person.setBodyFeatures(bodyFeatures);
            }
            bodyFeatures.add(bodyFeature);
        }
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("configMap");
        this.executionContextThreadLocal.remove();
    }
}

