/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.content.FaceDataContent;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="faceDataValidProcessor")
public class FaceDataValidProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private Logger logger = LoggerFactory.getLogger(FaceDataValidProcessor.class);
    @Value(value="${vion.data.ignore-before-day:30}")
    private int ignoreBeforeDay;

    public FaceDataContent process(FaceDataContent item) throws Exception {
        this.logger.debug("\u5f00\u59cb\u4eba\u8138\u6570\u636e\u6709\u6548\u6027\u6821\u9a8c");
        if (item.getCountDate() == null) {
            return null;
        }
        if (Math.abs(System.currentTimeMillis() - item.getCountDate().getTime()) > TimeUnit.DAYS.toMillis(this.ignoreBeforeDay)) {
            return null;
        }
        return item;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void close() throws ItemStreamException {
    }
}

