/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component(value="faceDataIsRepeatProcessor")
public class FaceDataIsRepeatProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private static final Object faceDataKeySync = new Object();
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private Logger logger = LoggerFactory.getLogger(FaceDataIsRepeatProcessor.class);

    public FaceDataContent process(FaceDataContent item) throws Exception {
        this.logger.debug("\u5f00\u59cb\u4eba\u8138\u91cd\u590d\u6293\u6015\u5224\u65ad\u9a8c\u8bc1");
        if (this.isRepeat(item)) {
            this.logger.info("\u4eba\u8138\u6293\u62cd\u91cd\u590d\u8df3\u8fc7\uff0c\u901a\u9053\u53f7\u4e3a:{},counttime\u4e3a:{},personUnid:{}", new Object[]{item.getChannelSerialnum(), DateUtil.format((String)DateUtil.FORMAT_YYYY_MM_DD_HH_MM, (Date)item.getCountDate()), item.getPersonId()});
            return null;
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRepeat(FaceDataContent item) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date counttime = item.getCountDate();
        StringBuilder sb = new StringBuilder();
        sb.append(item.getChannelSerialnum());
        sb.append(":");
        sb.append(sdf.format(counttime));
        sb.append(":");
        sb.append(item.getPersonId());
        String key = sb.toString();
        String datestr = DateUtil.format((String)"yyyyMMdd", (Date)item.getCountDate());
        String faceRecognitionKey = "faceRecognitionKey:" + datestr + ":" + item.getMallId();
        if (!this.redisTemplate.expire((Object)faceRecognitionKey, 2L, TimeUnit.HOURS).booleanValue()) {
            Object object = faceDataKeySync;
            synchronized (object) {
                if (!this.redisTemplate.hasKey((Object)faceRecognitionKey).booleanValue()) {
                    List faceDataContentList = this.jdbcTemplate.query("select channel_serialnum as channelSerialnum,counttime as countDate,person_unid as personId From d_face_recognition where countdate = ? and mall_id =?", new Object[]{item.getCountDate(), item.getMallId()}, (RowMapper)new BeanPropertyRowMapper(FaceDataContent.class));
                    if (faceDataContentList.isEmpty()) {
                        this.redisTemplate.boundSetOps((Object)faceRecognitionKey).add(new Object[]{key});
                        return false;
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    for (FaceDataContent faceDataContent : faceDataContentList) {
                        if (faceDataContent.getChannelSerialnum() == null && faceDataContent.getCountDate() == null) continue;
                        list.add(faceDataContent.getChannelSerialnum() + ":" + sdf.format(faceDataContent.getCountDate()) + ":" + faceDataContent.getPersonId());
                    }
                    this.redisTemplate.execute((SessionCallback)new /* Unavailable Anonymous Inner Class!! */);
                    this.redisTemplate.expire((Object)faceRecognitionKey, 2L, TimeUnit.HOURS);
                }
            }
        }
        return this.redisTemplate.boundSetOps((Object)faceRecognitionKey).add(new Object[]{key}) <= 0L;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void close() throws ItemStreamException {
    }
}

