/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.content.CountDataContent;
import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.model.Gate;
import com.viontech.keliu.redis.RedisUtil;
import com.viontech.keliu.service.OrgCacheService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dataFilterProcessor")
public class DataFilterProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private final Logger logger = LoggerFactory.getLogger(DataFilterProcessor.class);
    @Autowired
    private OrgCacheService orgCacheService;

    public FaceDataContent process(FaceDataContent item) {
        Gate gate;
        Map gateMap = this.orgCacheService.getGateMap();
        if (gateMap != null && !gateMap.isEmpty() && (gate = (Gate)gateMap.get(String.valueOf(item.getGateId()))) != null && gate.getType() == 5) {
            return item;
        }
        CountDataContent cdc = new CountDataContent();
        cdc.setVasid(item.getVasId());
        cdc.setInnum(0);
        cdc.setOutnum(0);
        if (item.getDirection() == 1) {
            cdc.setInnum(1);
        } else if (item.getDirection() == -1) {
            cdc.setOutnum(1);
        }
        cdc.setChannelno(item.getChannelSerialnum());
        cdc.setCreateTime(item.getCountDate());
        cdc.setStatus(Integer.valueOf(1));
        RedisUtil.addList((String)"countData", (Object)cdc);
        return item;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void close() throws ItemStreamException {
    }
}

