/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.model.ConfigParam;
import com.viontech.keliu.model.MatchParam;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.service.ConfigParamService;
import com.viontech.keliu.service.CustomMatchService;
import com.viontech.keliu.util.ConfigUtil;
import com.viontech.keliu.websocket.AlgApiClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="customRecognitionProcessor")
public class CustomRecognitionProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private final Logger logger = LoggerFactory.getLogger(CustomRecognitionProcessor.class);
    @Autowired(required=false)
    private AlgApiClient algApiClientComparison;
    @Value(value="${match.score.custom}")
    private Integer matchScoreCustom;
    @Value(value="${match.score.custom.append:78}")
    private Integer matchScoreCustomAppend;
    @Value(value="${match.score.camera:1.5}")
    private Float matchScoreCamera;
    @Autowired
    private ConfigParamService configParamService;
    @Autowired
    private CustomMatchService customMatchService;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();

    public CustomRecognitionProcessor() {
        this.logger.info("\u521b\u5efaCustomRecognitionProcessor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FaceDataContent process(FaceDataContent item) throws Exception {
        this.logger.info("\u5f00\u59cb\u5904\u7406\u987e\u5ba2\u6bd4\u5bf9");
        try {
            if (this.algApiClientComparison == null) {
                FaceDataContent faceDataContent = item;
                return faceDataContent;
            }
            if (item.getPerson() == null) {
                this.logger.info("\u5f00\u59cb\u5904\u7406\u987e\u5ba2\u6bd4\u5bf9");
                FaceDataContent faceDataContent = item;
                return faceDataContent;
            }
            if (item.getMallId() == null) {
                this.logger.debug("\u8be5\u6761\u4eba\u8138\u6570\u636e\u7684mallId\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u987e\u5ba2\u6bd4\u5bf9\u529f\u80fd\uff01");
                FaceDataContent faceDataContent = item;
                return faceDataContent;
            }
            Integer personType = item.getPersonType();
            if (personType != null && personType != 0) {
                FaceDataContent faceDataContent = item;
                return faceDataContent;
            }
            item.setPersonType(Integer.valueOf(0));
            Map configParamMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("configMap");
            ConfigParam configParam = ConfigUtil.getConfigParam((Long)item.getMallId(), (Map)configParamMap);
            String custom = configParam.getCustom();
            if ("0".equals(custom)) {
                this.logger.debug("\u5546\u573aid\u4e3a{}\u7684\u5546\u573a\u5173\u95ed\u987e\u5ba2\u6bd4\u5bf9\u529f\u80fd,\u8df3\u8fc7\u987e\u5ba2\u6bd4\u5bf9\u5904\u7406", (Object)item.getMallId());
                FaceDataContent faceDataContent = item;
                return faceDataContent;
            }
            MatchParam matchParam = new MatchParam();
            matchParam.setMallId(item.getMallId());
            matchParam.setAppend(true);
            ArrayList<Date> dates = new ArrayList<Date>();
            dates.add(item.getCountDate());
            matchParam.setDates(dates);
            matchParam.setFaceScore(item.getFace_score());
            matchParam.setFaceScoerThreshold(this.matchScoreCamera);
            matchParam.setMatchThreshold(this.matchScoreCustom.intValue());
            matchParam.setAppendThreshold(this.matchScoreCustomAppend.intValue());
            matchParam.setSubPool(configParam.getSubPool() == null ? true : "1".equals(configParam.getSubPool()));
            List matchResult = this.customMatchService.match(item.getPerson(), matchParam);
            if (matchResult != null && matchResult.size() > 0) {
                item.setPersonId(((Person)matchResult.get(0)).getPersonId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            item.setPerson(null);
        }
        return item;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("configMap");
        this.executionContextThreadLocal.remove();
    }
}

