/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.support.CompositeItemProcessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CompositeItemStreamProcessor<I, O>
extends CompositeItemProcessor<I, O>
implements ItemStream,
ItemProcessor<I, O>,
InitializingBean {
    private boolean ignoreItemStream = false;
    private Logger logger = LoggerFactory.getLogger(CompositeItemStreamProcessor.class);
    private List<? extends ItemProcessor<?, ?>> delegates;

    public void setIgnoreItemStream(boolean ignoreItemStream) {
        this.ignoreItemStream = ignoreItemStream;
    }

    public O process(I item) throws Exception {
        Object result = item;
        long startAll = System.currentTimeMillis();
        for (ItemProcessor delegate : this.delegates) {
            if (result == null) {
                return null;
            }
            long start = System.currentTimeMillis();
            result = this.processItem(delegate, result);
            long end = System.currentTimeMillis();
            long c = end - start;
            if (c <= 1L) continue;
            this.logger.info(delegate.getClass().getSimpleName() + "Processor\u6267\u884c\u65f6\u95f4:" + (end - start));
        }
        this.logger.info(item.getClass().getSimpleName() + "\u6574\u4f53\u5904\u7406\u65f6\u95f4:" + (System.currentTimeMillis() - startAll));
        return (O)result;
    }

    private <T> Object processItem(ItemProcessor<T, ?> processor, Object input) throws Exception {
        return processor.process(input);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.delegates, (String)"The 'delegates' may not be null");
        Assert.notEmpty((Collection)this.delegates, (String)"The 'delegates' may not be empty");
    }

    public void setDelegates(List<? extends ItemProcessor<?, ?>> delegates) {
        this.delegates = delegates;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        for (ItemProcessor processor : this.delegates) {
            if (this.ignoreItemStream || !(processor instanceof ItemStream)) continue;
            ((ItemStream)processor).open(executionContext);
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        for (ItemProcessor processor : this.delegates) {
            if (this.ignoreItemStream || !(processor instanceof ItemStream)) continue;
            ((ItemStream)processor).update(executionContext);
        }
    }

    public void close() throws ItemStreamException {
        for (ItemProcessor processor : this.delegates) {
            if (this.ignoreItemStream || !(processor instanceof ItemStream)) continue;
            ((ItemStream)processor).close();
        }
    }
}

