/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.baidu.aip.face.AipFace;
import com.baidu.aip.util.Base64Util;
import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.model.ConfigParam;
import com.viontech.keliu.service.ConfigParamService;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.util.ConfigUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.stereotype.Component;

@Component(value="baiduCalibrateInfoProcessor")
public class BaiduCalibrateInfoProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private final Logger logger = LoggerFactory.getLogger(BaiduCalibrateInfoProcessor.class);
    public static final String APP_ID = "11351054";
    public static final String API_KEY = "F2o8riIQhPlPjIXIyHb8i57F";
    public static final String SECRET_KEY = "IsisWL9pmufGptccS6G2joyZKZ4SjULR";
    final AipFace client = new AipFace("11351054", "F2o8riIQhPlPjIXIyHb8i57F", "IsisWL9pmufGptccS6G2joyZKZ4SjULR");
    @Resource
    private Storage imageStorage;
    @Resource
    private ConfigParamService configParamService;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();

    public BaiduCalibrateInfoProcessor() {
        this.client.setConnectionTimeoutInMillis(2000);
        this.client.setSocketTimeoutInMillis(60000);
    }

    public FaceDataContent process(FaceDataContent item) throws Exception {
        if (item.getMallId() == null) {
            this.logger.debug("\u8be5\u6761\u4eba\u8138\u6570\u636e\u7684mallId\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u540e\u7aef\u6bd4\u5bf9\u529f\u80fd\uff01");
            return item;
        }
        Map configParamMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("configMap");
        ConfigParam configParam = ConfigUtil.getConfigParam((Long)item.getMallId(), (Map)configParamMap);
        String calibrate = configParam.getCalibrate();
        if ("0".equals(calibrate)) {
            this.logger.debug("\u5546\u573aid\u4e3a{}\u7684\u5546\u573a\u5173\u95ed\u540e\u7aef\u6bd4\u5bf9\u529f\u80fd,\u8df3\u8fc7\u540e\u7aef\u6bd4\u5bf9\u5904\u7406", (Object)item.getMallId());
            return item;
        }
        String frrArrivalFacePicture1 = item.getFacePic();
        if (frrArrivalFacePicture1 == null || frrArrivalFacePicture1.trim().isEmpty()) {
            return item;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("max_face_num", "1");
        options.put("face_field", "age,expression,gender");
        try {
            byte[] bytes = this.imageStorage.getByteArrayItem(item.getChannelSerialnum() + "/" + frrArrivalFacePicture1);
            if (bytes == null) {
                return item;
            }
            String image1 = Base64Util.encode((byte[])bytes);
            JSONObject response = this.client.detect(image1, "BASE64", options);
            int resultNum = 0;
            if (response.keySet().contains("error_code") && "0".equals(String.valueOf(response.get("error_code"))) && response.getJSONObject("result").keySet().contains("face_num")) {
                resultNum = response.getJSONObject("result").getInt("face_num");
            }
            if (resultNum == 0) {
                return item;
            }
            JSONObject jsonObject = response.getJSONObject("result").getJSONArray("face_list").getJSONObject(0);
            if (jsonObject.getDouble("face_probability") < 0.8) {
                return item;
            }
            double age = jsonObject.getDouble("age");
            String gender = jsonObject.getJSONObject("gender").getString("type");
            item.setAge((int)age);
            if (item.getGender() == -1) {
                item.setGender("male".equals(gender) ? 1 : 0);
            }
        }
        catch (Exception e) {
            this.logger.error("\u8fdb\u884c\u540e\u53f0\u8bc6\u522b\u65f6\u53d1\u751f\u95ee\u9898", (Throwable)e);
            e.printStackTrace();
        }
        return item;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("configMap");
        this.executionContextThreadLocal.remove();
    }
}

