/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.MapStepExecutionDao;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.SerializationUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class VionMapStepExecutionDao
extends MapStepExecutionDao {
    private Map<Long, Map<Long, StepExecution>> executionsByJobExecutionId = new ConcurrentHashMap();
    private Map<Long, StepExecution> executionsByStepExecutionId = new ConcurrentHashMap();
    private AtomicLong currentId = new AtomicLong();

    public void clear() {
        this.executionsByJobExecutionId.clear();
        this.executionsByStepExecutionId.clear();
    }

    private static StepExecution copy(StepExecution original) {
        return (StepExecution)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Object)original));
    }

    private static void copy(StepExecution sourceExecution, StepExecution targetExecution) {
        ReflectionUtils.doWithFields(StepExecution.class, (ReflectionUtils.FieldCallback)new /* Unavailable Anonymous Inner Class!! */, (ReflectionUtils.FieldFilter)ReflectionUtils.COPYABLE_FIELDS);
    }

    public void saveStepExecution(StepExecution stepExecution) {
        Assert.isTrue((stepExecution.getId() == null ? 1 : 0) != 0, (String)"stepExecution id was not null");
        Assert.isTrue((stepExecution.getVersion() == null ? 1 : 0) != 0, (String)"stepExecution version was not null");
        Assert.notNull((Object)stepExecution.getJobExecutionId(), (String)"JobExecution must be saved already.");
        ConcurrentHashMap<Long, StepExecution> executions = (ConcurrentHashMap<Long, StepExecution>)this.executionsByJobExecutionId.get(stepExecution.getJobExecutionId());
        if (executions == null) {
            executions = new ConcurrentHashMap<Long, StepExecution>();
            this.executionsByJobExecutionId.put(stepExecution.getJobExecutionId(), executions);
        }
        stepExecution.setId(Long.valueOf(this.currentId.incrementAndGet()));
        stepExecution.incrementVersion();
        StepExecution copy = VionMapStepExecutionDao.copy((StepExecution)stepExecution);
        executions.put(stepExecution.getId(), copy);
        this.executionsByStepExecutionId.put(stepExecution.getId(), copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStepExecution(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution.getJobExecutionId(), (String)"jobExecution id is null");
        Map executions = (Map)this.executionsByJobExecutionId.get(stepExecution.getJobExecutionId());
        Assert.notNull((Object)executions, (String)"step executions for given job execution are expected to be already saved");
        StepExecution persistedExecution = (StepExecution)this.executionsByStepExecutionId.get(stepExecution.getId());
        Assert.notNull((Object)persistedExecution, (String)"step execution is expected to be already saved");
        StepExecution stepExecution2 = stepExecution;
        synchronized (stepExecution2) {
            if (!persistedExecution.getVersion().equals(stepExecution.getVersion())) {
                throw new OptimisticLockingFailureException("Attempt to update step execution id=" + stepExecution.getId() + " with wrong version (" + stepExecution.getVersion() + "), where current version is " + persistedExecution.getVersion());
            }
            stepExecution.incrementVersion();
            StepExecution copy = new StepExecution(stepExecution.getStepName(), stepExecution.getJobExecution());
            VionMapStepExecutionDao.copy((StepExecution)stepExecution, (StepExecution)copy);
            executions.put(stepExecution.getId(), copy);
            this.executionsByStepExecutionId.put(stepExecution.getId(), copy);
        }
    }

    public StepExecution getStepExecution(JobExecution jobExecution, Long stepExecutionId) {
        return (StepExecution)this.executionsByStepExecutionId.get(stepExecutionId);
    }

    public void addStepExecutions(JobExecution jobExecution) {
        Map executions = (Map)this.executionsByJobExecutionId.get(jobExecution.getId());
        if (executions == null || executions.isEmpty()) {
            return;
        }
        ArrayList result = new ArrayList(executions.values());
        Collections.sort(result, new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<StepExecution> copy = new ArrayList<StepExecution>(result.size());
        for (StepExecution exec : result) {
            copy.add(VionMapStepExecutionDao.copy((StepExecution)exec));
        }
        jobExecution.addStepExecutions(copy);
    }

    public void saveStepExecutions(Collection<StepExecution> stepExecutions) {
        Assert.notNull(stepExecutions, (String)"Attempt to save an null collect of step executions");
        for (StepExecution stepExecution : stepExecutions) {
            this.saveStepExecution(stepExecution);
        }
    }

    public void clear(StepExecution stepExecution) {
        Long stepExecutionId = stepExecution.getId();
        this.executionsByStepExecutionId.remove(stepExecutionId);
        Map stepExecutionMap = (Map)this.executionsByJobExecutionId.get(stepExecution.getJobExecutionId());
        if (stepExecutionMap != null && stepExecutionMap.size() > 0) {
            stepExecutionMap.remove(stepExecutionId);
        }
        if (stepExecutionMap == null || stepExecutionMap.size() <= 0) {
            this.executionsByJobExecutionId.remove(stepExecution.getJobExecutionId());
        }
    }
}

