/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.dao;

import com.viontech.keliu.batch.dao.VionMapExecutionContextDao;
import com.viontech.keliu.batch.dao.VionMapJobExecutionDao;
import com.viontech.keliu.batch.dao.VionMapJobInstanceDao;
import com.viontech.keliu.batch.dao.VionMapStepExecutionDao;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.core.repository.support.MapJobRepositoryFactoryBean;
import org.springframework.batch.support.transaction.ResourcelessTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public class VionMapJobRepositoryFactoryBean
extends MapJobRepositoryFactoryBean {
    private final Logger logger = LoggerFactory.getLogger(VionMapJobRepositoryFactoryBean.class);
    private VionMapJobExecutionDao jobExecutionDao;
    private VionMapJobInstanceDao jobInstanceDao;
    private VionMapStepExecutionDao stepExecutionDao;
    private VionMapExecutionContextDao executionContextDao;

    public VionMapJobRepositoryFactoryBean() {
        this((PlatformTransactionManager)new ResourcelessTransactionManager());
    }

    public VionMapJobRepositoryFactoryBean(PlatformTransactionManager transactionManager) {
        this.setTransactionManager(transactionManager);
    }

    public JobExecutionDao getJobExecutionDao() {
        return this.jobExecutionDao;
    }

    public JobInstanceDao getJobInstanceDao() {
        return this.jobInstanceDao;
    }

    public StepExecutionDao getStepExecutionDao() {
        return this.stepExecutionDao;
    }

    public ExecutionContextDao getExecutionContextDao() {
        return this.executionContextDao;
    }

    public void clear() {
        List jobNameList = this.jobInstanceDao.getJobNames();
        HashSet jobNames = new HashSet(jobNameList);
        jobNames.forEach(jobName -> {
            this.logger.info("\u5f00\u59cb\u6e05\u9664\u4efb\u52a1:{}", jobName);
            try {
                int jobInstanceCount = this.jobInstanceDao.getJobInstanceCount(jobName);
                List jobInstances = this.jobInstanceDao.getJobInstances(jobName, 0, jobInstanceCount);
                jobInstances.forEach(jobInstance -> {
                    List jobExecutions = this.jobExecutionDao.findJobExecutions(jobInstance);
                    jobExecutions.forEach(jobExecution -> {
                        if (!jobExecution.isRunning()) {
                            Collection stepExecutions = jobExecution.getStepExecutions();
                            stepExecutions.forEach(stepExecution -> {
                                this.executionContextDao.clear(stepExecution);
                                this.stepExecutionDao.clear(stepExecution);
                            });
                            this.executionContextDao.clear(jobExecution);
                            this.jobExecutionDao.clear(jobExecution);
                        }
                    });
                    jobExecutions = this.jobExecutionDao.findJobExecutions(jobInstance);
                    if (jobExecutions == null || jobExecutions.size() <= 0) {
                        this.logger.info("\u6e05\u9664\u4efb\u52a1\u5b9e\u4f8b:{}", (Object)jobInstance.getId());
                        this.jobInstanceDao.clear(jobInstance);
                    }
                });
            }
            catch (NoSuchJobException e) {
                e.printStackTrace();
            }
        });
    }

    protected JobExecutionDao createJobExecutionDao() throws Exception {
        this.jobExecutionDao = new VionMapJobExecutionDao();
        return this.jobExecutionDao;
    }

    protected JobInstanceDao createJobInstanceDao() throws Exception {
        this.jobInstanceDao = new VionMapJobInstanceDao();
        return this.jobInstanceDao;
    }

    protected StepExecutionDao createStepExecutionDao() throws Exception {
        this.stepExecutionDao = new VionMapStepExecutionDao();
        return this.stepExecutionDao;
    }

    protected ExecutionContextDao createExecutionContextDao() throws Exception {
        this.executionContextDao = new VionMapExecutionContextDao();
        return this.executionContextDao;
    }
}

