/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.repository.dao.MapJobExecutionDao;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.util.Assert;
import org.springframework.util.SerializationUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class VionMapJobExecutionDao
extends MapJobExecutionDao {
    private final ConcurrentMap<Long, JobExecution> executionsById = new ConcurrentHashMap();
    private final AtomicLong currentId = new AtomicLong(0L);

    public void clear() {
        this.executionsById.clear();
    }

    private static JobExecution copy(JobExecution original) {
        JobExecution copy = (JobExecution)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Object)original));
        return copy;
    }

    public void saveJobExecution(JobExecution jobExecution) {
        Assert.isTrue((jobExecution.getId() == null ? 1 : 0) != 0, (String)"jobExecution id is not null");
        Long newId = this.currentId.getAndIncrement();
        jobExecution.setId(newId);
        jobExecution.incrementVersion();
        this.executionsById.put(newId, VionMapJobExecutionDao.copy((JobExecution)jobExecution));
    }

    public List<JobExecution> findJobExecutions(JobInstance jobInstance) {
        ArrayList<JobExecution> executions = new ArrayList<JobExecution>();
        for (JobExecution exec : this.executionsById.values()) {
            if (!exec.getJobInstance().equals((Object)jobInstance)) continue;
            executions.add(VionMapJobExecutionDao.copy((JobExecution)exec));
        }
        Collections.sort(executions, new /* Unavailable Anonymous Inner Class!! */);
        return executions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobExecution(JobExecution jobExecution) {
        Long id = jobExecution.getId();
        Assert.notNull((Object)id, (String)"JobExecution is expected to have an id (should be saved already)");
        JobExecution persistedExecution = (JobExecution)this.executionsById.get(id);
        Assert.notNull((Object)persistedExecution, (String)"JobExecution must already be saved");
        JobExecution jobExecution2 = jobExecution;
        synchronized (jobExecution2) {
            if (!persistedExecution.getVersion().equals(jobExecution.getVersion())) {
                throw new OptimisticLockingFailureException("Attempt to update step execution id=" + id + " with wrong version (" + jobExecution.getVersion() + "), where current version is " + persistedExecution.getVersion());
            }
            jobExecution.incrementVersion();
            this.executionsById.put(id, VionMapJobExecutionDao.copy((JobExecution)jobExecution));
        }
    }

    public JobExecution getLastJobExecution(JobInstance jobInstance) {
        JobExecution lastExec = null;
        for (JobExecution exec : this.executionsById.values()) {
            if (!exec.getJobInstance().equals((Object)jobInstance)) continue;
            if (lastExec == null) {
                lastExec = exec;
            }
            if (!lastExec.getCreateTime().before(exec.getCreateTime())) continue;
            lastExec = exec;
        }
        return VionMapJobExecutionDao.copy(lastExec);
    }

    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        HashSet<JobExecution> result = new HashSet<JobExecution>();
        for (JobExecution exec : this.executionsById.values()) {
            if (!exec.getJobInstance().getJobName().equals(jobName) || !exec.isRunning()) continue;
            result.add(VionMapJobExecutionDao.copy((JobExecution)exec));
        }
        return result;
    }

    public JobExecution getJobExecution(Long executionId) {
        return VionMapJobExecutionDao.copy((JobExecution)((JobExecution)this.executionsById.get(executionId)));
    }

    public void synchronizeStatus(JobExecution jobExecution) {
        JobExecution saved = this.getJobExecution(jobExecution.getId());
        if (saved.getVersion().intValue() != jobExecution.getVersion().intValue()) {
            jobExecution.upgradeStatus(saved.getStatus());
            jobExecution.setVersion(saved.getVersion());
        }
    }

    public void clear(JobExecution jobExecution) {
        this.executionsById.remove(jobExecution.getId());
    }
}

