/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.configuration;

import com.viontech.keliu.batch.item.reader.RedisPopReader;
import com.viontech.keliu.batch.item.writer.RedisListWriter;
import com.viontech.keliu.batch.listener.ExecutionContextClearListener;
import com.viontech.keliu.batch.listener.JobRestartListener;
import com.viontech.keliu.batch.listener.StepLoggerListener;
import com.viontech.keliu.batch.listener.WorkQueueClearChunkListener;
import com.viontech.keliu.content.MultiPCountRecordContent;
import com.viontech.keliu.model.Retention;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.JdbcBatchItemWriter;
import org.springframework.batch.item.support.CompositeItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class RawHeatmapDataJobConfiguration {
    private Logger logger = LoggerFactory.getLogger(RawHeatmapDataJobConfiguration.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Value(value="${spring.batch.job.chunkSize:1}")
    private int chunkSize;

    @Bean(name={"rawHeatmapDataProcessJob"})
    public Job rawHeatMapDataProcessJob(JobRepository jobRepository, Step rawHeatmapDataStep, JobRestartListener jobRestartListener) {
        return ((JobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("rawHeatmapDataProcessJob").listener((JobExecutionListener)jobRestartListener)).incrementer((JobParametersIncrementer)new RunIdIncrementer())).repository(jobRepository)).start(rawHeatmapDataStep).build();
    }

    @Bean(name={"rawHeatmapDataStep"})
    public Step rawHeatmapDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, ItemReader<MultiPCountRecordContent> rawHeatmapDataReader4Redis, ItemProcessor<MultiPCountRecordContent, Retention> heatMapDataProcessor, ItemWriter rawHeatmapDataCompositeWriter) {
        RepeatTemplate stepOperations = new RepeatTemplate();
        stepOperations.setCompletionPolicy((CompletionPolicy)new /* Unavailable Anonymous Inner Class!! */);
        return ((StepBuilder)((StepBuilder)this.stepBuilderFactory.get("rawHeatmapDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).listener((StepExecutionListener)new StepLoggerListener())).chunk(this.chunkSize).reader(rawHeatmapDataReader4Redis).processor(heatMapDataProcessor).writer(rawHeatmapDataCompositeWriter).stepOperations((RepeatOperations)stepOperations).listener((ChunkListener)new WorkQueueClearChunkListener()).build();
    }

    @Bean(value={"rawHeatmapDataReader4Redis"})
    public ItemReader rawHeatmapDataReader4Redis(RedisTemplate redisTemplate, @Value(value="#{'${spring.cloud.client.ip-address}'+':'+'${server.port}'}") String ipPort) {
        RedisPopReader redisPopReader = new RedisPopReader();
        redisPopReader.setRedisTemplate(redisTemplate);
        redisPopReader.setKey("multiPCountRecords_V2");
        redisPopReader.setPopType(2);
        redisPopReader.setInstanceId(ipPort);
        return redisPopReader;
    }

    @Bean(name={"rawHeatmapData2DBWriter"})
    public ItemWriter rawHeatmapData2DBWriter(DataSource dataSource) {
        JdbcBatchItemWriter writer = new JdbcBatchItemWriter();
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        String sql = "INSERT INTO d_heatmap_data_raw (device_serialnum, channel_serialnum, x, y,fx,fy,rx,ry, size, score, counttime,countdate) VALUES (:deviceSerialnum,:channelSerialnum, :x, :y, :fx,:fy,:rx,:ry,:size, :score, :counttime,:counttime)";
        writer.setSql(sql);
        writer.setDataSource(dataSource);
        return writer;
    }

    @Bean(name={"rawRetention2DBWriter"})
    public ItemWriter gateRetention2DBWriter(DataSource dataSource) {
        JdbcBatchItemWriter writer = new JdbcBatchItemWriter();
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        String sql = "INSERT INTO d_retention_raw (device_serialnum, channel_serialnum,gate_id,num, counttime,countdate) VALUES (:deviceSerialnum,:channelSerialnum,:gateId,:num, :counttime,:counttime)";
        writer.setSql(sql);
        writer.setDataSource(dataSource);
        return writer;
    }

    @Bean(name={"rententionData2RedisWriter"})
    public ItemWriter rententionData2RedisWriter(RedisTemplate redisTemplate) {
        RedisListWriter writer = new RedisListWriter(redisTemplate, "rententionData");
        return writer;
    }

    @Bean(name={"rawHeatmapDataCompositeWriter"})
    public ItemWriter rawHeatmapDataCompositeWriter(ItemWriter rawHeatmapData2DBWriter, ItemWriter rawRetention2DBWriter, ItemWriter rententionData2RedisWriter) {
        CompositeItemWriter compositeItemWriter = new CompositeItemWriter();
        ArrayList<ItemWriter> delegates = new ArrayList<ItemWriter>();
        delegates.add(items -> {
            ArrayList<Retention.Record> records = new ArrayList<Retention.Record>();
            for (Retention content : items) {
                List contentRecords = content.getRecords();
                for (Retention.Record contentRecord : contentRecords) {
                    records.add(contentRecord);
                }
            }
            rawHeatmapData2DBWriter.write(records);
        });
        delegates.add(rawRetention2DBWriter);
        delegates.add(items -> {
            ArrayList<Retention> retentions = new ArrayList<Retention>();
            for (Retention content : items) {
                content.setRecords(null);
                retentions.add(content);
            }
            rententionData2RedisWriter.write(retentions);
        });
        compositeItemWriter.setDelegates(delegates);
        return compositeItemWriter;
    }
}

