/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.configuration;

import com.viontech.keliu.batch.configuration.GateRetentionDataJobConfiguration;
import com.viontech.keliu.batch.item.reader.RedisPopReader;
import com.viontech.keliu.batch.listener.ExecutionContextClearListener;
import com.viontech.keliu.batch.listener.JobRestartListener;
import com.viontech.keliu.batch.listener.StepLoggerListener;
import com.viontech.keliu.model.Retention;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class GateRetentionDataJobConfiguration {
    private Logger logger = LoggerFactory.getLogger(GateRetentionDataJobConfiguration.class);
    private static final Object gateRetentionDataRawKeySync = new Object();
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${spring.batch.job.chunkSize:1}")
    private int chunkSize;

    @Bean(name={"gateRetentionDataProcessJob"})
    public Job gateRetentionDataProcessJob(JobRepository jobRepository, Step gateRetentionDataStep, JobRestartListener jobRestartListener) {
        return ((JobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("gateRetentionDataProcessJob").listener((JobExecutionListener)jobRestartListener)).incrementer((JobParametersIncrementer)new RunIdIncrementer())).repository(jobRepository)).start(gateRetentionDataStep).build();
    }

    @Bean(name={"gateRetentionDataStep"})
    public Step gateRetentionDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, ItemReader<Retention> gateRetentionDataReader4Redis, ItemProcessor<Retention, Retention> gateRetentionDataProcessor, ItemWriter rententionData2DBWriter) {
        RepeatTemplate stepOperations = new RepeatTemplate();
        stepOperations.setCompletionPolicy((CompletionPolicy)new /* Unavailable Anonymous Inner Class!! */);
        TaskletStep step = ((StepBuilder)((StepBuilder)this.stepBuilderFactory.get("gateRetentionDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).listener((StepExecutionListener)new StepLoggerListener())).chunk(this.chunkSize).reader(gateRetentionDataReader4Redis).processor(gateRetentionDataProcessor).writer(rententionData2DBWriter).stepOperations((RepeatOperations)stepOperations).build();
        return step;
    }

    @Bean(value={"gateRetentionDataReader4Redis"})
    public ItemReader gateRetentionDataReader4Redis(RedisTemplate redisTemplate) {
        RedisPopReader redisPopReader = new RedisPopReader();
        redisPopReader.setRedisTemplate(redisTemplate);
        redisPopReader.setKey("rententionData");
        return redisPopReader;
    }

    @Bean(name={"rententionData2DBWriter"})
    public ItemWriter rententionData2DBWriter(DataSource dataSource) {
        String insertsql = "INSERT INTO d_gate_retention (gate_id,mall_id,account_id,num,counttime,countdate) VALUES(:gateId,:mallId,:accountId,:num,:counttime,:counttime)";
        String updatesql = "UPDATE d_gate_retention SET num=num+:num where gate_id=:gateId AND counttime=:counttime";
        2 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    static /* synthetic */ RedisTemplate access$000(GateRetentionDataJobConfiguration x0) {
        return x0.redisTemplate;
    }

    static /* synthetic */ Object access$100() {
        return gateRetentionDataRawKeySync;
    }

    static /* synthetic */ JdbcTemplate access$200(GateRetentionDataJobConfiguration x0) {
        return x0.jdbcTemplate;
    }
}

