/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.configuration;

import com.viontech.keliu.batch.configuration.FaceSta2DBJobConfiguration;
import com.viontech.keliu.batch.item.processor.FaceDataStaProcessor;
import com.viontech.keliu.batch.item.reader.RedisHashDataReader;
import com.viontech.keliu.batch.listener.ExecutionContextClearListener;
import com.viontech.keliu.batch.tasklet.FaceDataStaKey2RedisTasklet;
import com.viontech.keliu.service.FaceDataStaKeyService;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class FaceSta2DBJobConfiguration {
    private Logger logger = LoggerFactory.getLogger(FaceSta2DBJobConfiguration.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Resource
    private FaceDataStaKeyService keyService;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Value(value="${spring.batch.job.chunkSize:1}")
    private int chunkSize;

    @Bean(name={"faceDataStaRedis2DBJob"})
    public Job faceDataStaRedis2DBJob(JobRepository jobRepository, Step faceDataStaKey2RedisStep, Step mallFaceDataStaStep, Step floorFaceDataStaStep, Step zoneFaceDataStaStep, Step gateFaceDataStaStep, Step mallHourFaceDataStaStep, Step floorHourFaceDataStaStep, Step zoneHourFaceDataStaStep, Step gateHourFaceDataStaStep) {
        return ((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("faceDataStaRedis2DBJob").incrementer((JobParametersIncrementer)new RunIdIncrementer())).repository(jobRepository)).start(mallFaceDataStaStep).next(floorFaceDataStaStep).next(zoneFaceDataStaStep).next(gateFaceDataStaStep).next(mallHourFaceDataStaStep).next(floorHourFaceDataStaStep).next(zoneHourFaceDataStaStep).next(gateHourFaceDataStaStep).build();
    }

    @Bean(name={"faceDataStaKey2RedisStep"})
    public Step faceDataStaKey2RedisStep(FaceDataStaKey2RedisTasklet faceStaKey2RedisTasklet) {
        return ((StepBuilder)this.stepBuilderFactory.get("faceDataStaKey2RedisStep").listener((StepExecutionListener)new ExecutionContextClearListener())).tasklet((Tasklet)faceStaKey2RedisTasklet).build();
    }

    @Bean(name={"mallFaceDataStaStep"})
    public Step mallFaceDataStaStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter mallFaceDataSta2DBWriter) {
        FaceDataStaProcessor faceDataStaProcessor = new FaceDataStaProcessor();
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "faceSta:day:mall:*");
        return ((StepBuilder)this.stepBuilderFactory.get("mallFaceDataStaStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(1).reader((ItemReader)dataReader).processor((ItemProcessor)faceDataStaProcessor).writer(mallFaceDataSta2DBWriter).build();
    }

    @Bean(name={"mallHourFaceDataStaStep"})
    public Step mallHourFaceDataStaStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter mallHourFaceDataSta2DBWriter) {
        FaceDataStaProcessor faceDataStaProcessor = new FaceDataStaProcessor();
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "faceSta:hour:mall:*");
        return ((StepBuilder)this.stepBuilderFactory.get("mallHourFaceDataStaStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(1).reader((ItemReader)dataReader).processor((ItemProcessor)faceDataStaProcessor).writer(mallHourFaceDataSta2DBWriter).build();
    }

    @Bean(name={"floorFaceDataStaStep"})
    public Step floorFaceDataStaStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter floorFaceDataSta2DBWriter) {
        FaceDataStaProcessor faceDataStaProcessor = new FaceDataStaProcessor();
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "faceSta:day:floor:*");
        return ((StepBuilder)this.stepBuilderFactory.get("floorFaceDataStaStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(1).reader((ItemReader)dataReader).processor((ItemProcessor)faceDataStaProcessor).writer(floorFaceDataSta2DBWriter).build();
    }

    @Bean(name={"floorHourFaceDataStaStep"})
    public Step floorHourFaceDataStaStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter floorHourFaceDataSta2DBWriter) {
        FaceDataStaProcessor faceDataStaProcessor = new FaceDataStaProcessor();
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "faceSta:hour:floor:*");
        return ((StepBuilder)this.stepBuilderFactory.get("floorHourFaceDataStaStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(1).reader((ItemReader)dataReader).processor((ItemProcessor)faceDataStaProcessor).writer(floorHourFaceDataSta2DBWriter).build();
    }

    @Bean(name={"zoneFaceDataStaStep"})
    public Step zoneFaceDataStaStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter zoneFaceDataSta2DBWriter) {
        FaceDataStaProcessor faceDataStaProcessor = new FaceDataStaProcessor();
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "faceSta:day:zone:*");
        return ((StepBuilder)this.stepBuilderFactory.get("zoneFaceDataStaStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(1).reader((ItemReader)dataReader).processor((ItemProcessor)faceDataStaProcessor).writer(zoneFaceDataSta2DBWriter).build();
    }

    @Bean(name={"zoneHourFaceDataStaStep"})
    public Step zoneHourFaceDataStaStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter zoneHourFaceDataSta2DBWriter) {
        FaceDataStaProcessor faceDataStaProcessor = new FaceDataStaProcessor();
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "faceSta:hour:zone:*");
        return ((StepBuilder)this.stepBuilderFactory.get("zoneHourFaceDataStaStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(1).reader((ItemReader)dataReader).processor((ItemProcessor)faceDataStaProcessor).writer(zoneHourFaceDataSta2DBWriter).build();
    }

    @Bean(name={"gateFaceDataStaStep"})
    public Step gateFaceDataStaStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter gateFaceDataSta2DBWriter) {
        FaceDataStaProcessor faceDataStaProcessor = new FaceDataStaProcessor();
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "faceSta:day:gate:*");
        return ((StepBuilder)this.stepBuilderFactory.get("gateFaceDataStaStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(1).reader((ItemReader)dataReader).processor((ItemProcessor)faceDataStaProcessor).writer(gateFaceDataSta2DBWriter).build();
    }

    @Bean(name={"gateHourFaceDataStaStep"})
    public Step gateHourFaceDataStaStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter gateHourFaceDataSta2DBWriter) {
        FaceDataStaProcessor faceDataStaProcessor = new FaceDataStaProcessor();
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "faceSta:hour:gate:*");
        return ((StepBuilder)this.stepBuilderFactory.get("gateHourFaceDataStaStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(1).reader((ItemReader)dataReader).processor((ItemProcessor)faceDataStaProcessor).writer(gateHourFaceDataSta2DBWriter).build();
    }

    @Bean(name={"mallFaceDataSta2DBWriter"})
    public ItemWriter mallFaceDataSta2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_mall_day_face_recognition_sta (person_mantime, person_count, custom_mantime, custom_count, male_mantime, male_count, female_mantime, female_count, staff_mantime, staff_count, countdate, mall_id, account_id, male_stage, female_stage,counttime,new_custom_count,new_male_count,new_female_count,new_male_stage,new_female_stage,regular_custom_count,regular_male_count,regular_female_count,regular_male_stage,regular_female_stage) VALUES (:personMantime,:personCount,:customMantime,:customCount,:maleMantime,:maleCount,:femaleMantime,:femaleCount,:staffMantime,:staffCount,:countDate,:mallId,:accountId,:maleStage,:femaleStage,:countTime,:newCustomCount,:newMaleCount,:newFemaleCount,:newMaleStage,:newFemaleStage,:regularCustomCount,:regularMaleCount,:regularFemaleCount,:regularMaleStage,:regularFemaleStage);";
        String updateSql = "UPDATE d_mall_day_face_recognition_sta SET person_mantime=:personMantime, person_count=:personCount, custom_mantime=:customMantime, custom_count=:customCount, male_mantime=:maleMantime, male_count=:maleCount, female_mantime=:femaleMantime, female_count=:femaleCount, staff_mantime=:staffMantime, staff_count=:staffCount, countdate=:countDate, mall_id=:mallId, account_id=:accountId, male_stage=:maleStage, female_stage=:femaleStage, counttime=:countTime ,new_custom_count=:newCustomCount,new_male_count=:newMaleCount,new_female_count=:newFemaleCount,new_male_stage=:newMaleStage,new_female_stage=:newFemaleStage,regular_custom_count=:regularCustomCount,regular_male_count=:regularMaleCount,regular_female_count=:regularFemaleCount,regular_male_stage=:regularMaleStage,regular_female_stage=:regularFemaleStage WHERE mall_id=:mallId and countdate=:countDate ;";
        1 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"mallHourFaceDataSta2DBWriter"})
    public ItemWriter mallHourFaceDataSta2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_mall_hour_face_recognition_sta (person_mantime, person_count, custom_mantime, custom_count, male_mantime, male_count, female_mantime, female_count, staff_mantime, staff_count, countdate, mall_id, account_id, male_stage, female_stage,counttime,hour,new_custom_count,new_male_count,new_female_count,new_male_stage,new_female_stage,regular_custom_count,regular_male_count,regular_female_count,regular_male_stage,regular_female_stage) VALUES (:personMantime,:personCount,:customMantime,:customCount,:maleMantime,:maleCount,:femaleMantime,:femaleCount,:staffMantime,:staffCount,:countDate,:mallId,:accountId,:maleStage,:femaleStage,:countTime,:hour,:newCustomCount,:newMaleCount,:newFemaleCount,:newMaleStage,:newFemaleStage,:regularCustomCount,:regularMaleCount,:regularFemaleCount,:regularMaleStage,:regularFemaleStage);";
        String updateSql = "UPDATE d_mall_hour_face_recognition_sta SET person_mantime=:personMantime, person_count=:personCount, custom_mantime=:customMantime, custom_count=:customCount, male_mantime=:maleMantime, male_count=:maleCount, female_mantime=:femaleMantime, female_count=:femaleCount, staff_mantime=:staffMantime, staff_count=:staffCount, countdate=:countDate, mall_id=:mallId, account_id=:accountId, male_stage=:maleStage, female_stage=:femaleStage, counttime=:countTime,hour=:hour ,new_custom_count=:newCustomCount,new_male_count=:newMaleCount,new_female_count=:newFemaleCount,new_male_stage=:newMaleStage,new_female_stage=:newFemaleStage,regular_custom_count=:regularCustomCount,regular_male_count=:regularMaleCount,regular_female_count=:regularFemaleCount,regular_male_stage=:regularMaleStage,regular_female_stage=:regularFemaleStage WHERE mall_id=:mallId and countdate=:countDate and counttime=:countTime ;";
        2 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"floorFaceDataSta2DBWriter"})
    public ItemWriter floorFaceDataSta2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_floor_day_face_recognition_sta (person_mantime, person_count, custom_mantime, custom_count, male_mantime, male_count, female_mantime, female_count, staff_mantime, staff_count, countdate, mall_id, account_id, floor_id, male_stage, female_stage,counttime,new_custom_count,new_male_count,new_female_count,new_male_stage,new_female_stage,regular_custom_count,regular_male_count,regular_female_count,regular_male_stage,regular_female_stage) VALUES (:personMantime,:personCount,:customMantime,:customCount,:maleMantime,:maleCount,:femaleMantime,:femaleCount,:staffMantime,:staffCount,:countDate,:mallId,:accountId,:floorId,:maleStage,:femaleStage,:countTime,:newCustomCount,:newMaleCount,:newFemaleCount,:newMaleStage,:newFemaleStage,:regularCustomCount,:regularMaleCount,:regularFemaleCount,:regularMaleStage,:regularFemaleStage);";
        String updateSql = "UPDATE d_floor_day_face_recognition_sta SET person_mantime=:personMantime, person_count=:personCount, custom_mantime=:customMantime, custom_count=:customCount, male_mantime=:maleMantime, male_count=:maleCount, female_mantime=:femaleMantime, female_count=:femaleCount, staff_mantime=:staffMantime, staff_count=:staffCount, countdate=:countDate, mall_id=:mallId, account_id=:accountId, floor_id=:floorId, male_stage=:maleStage, female_stage=:femaleStage ,counttime=:countTime ,new_custom_count=:newCustomCount,new_male_count=:newMaleCount,new_female_count=:newFemaleCount,new_male_stage=:newMaleStage,new_female_stage=:newFemaleStage,regular_custom_count=:regularCustomCount,regular_male_count=:regularMaleCount,regular_female_count=:regularFemaleCount,regular_male_stage=:regularMaleStage,regular_female_stage=:regularFemaleStage WHERE  mall_id=:mallId and floor_id=:floorId and countdate = :countDate;";
        3 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"floorHourFaceDataSta2DBWriter"})
    public ItemWriter floorHourFaceDataSta2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_floor_hour_face_recognition_sta (person_mantime, person_count, custom_mantime, custom_count, male_mantime, male_count, female_mantime, female_count, staff_mantime, staff_count, countdate, mall_id, account_id, floor_id, male_stage, female_stage,counttime,hour) VALUES (:personMantime,:personCount,:customMantime,:customCount,:maleMantime,:maleCount,:femaleMantime,:femaleCount,:staffMantime,:staffCount,:countDate,:mallId,:accountId,:floorId,:maleStage,:femaleStage,:countTime,:hour);";
        String updateSql = "UPDATE d_floor_hour_face_recognition_sta SET person_mantime=:personMantime, person_count=:personCount, custom_mantime=:customMantime, custom_count=:customCount, male_mantime=:maleMantime, male_count=:maleCount, female_mantime=:femaleMantime, female_count=:femaleCount, staff_mantime=:staffMantime, staff_count=:staffCount, countdate=:countDate, mall_id=:mallId, account_id=:accountId, floor_id=:floorId, male_stage=:maleStage, female_stage=:femaleStage ,counttime=:countTime ,hour=:hour WHERE  mall_id=:mallId and floor_id=:floorId and countdate=:countDate and counttime = :countTime;";
        4 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"zoneFaceDataSta2DBWriter"})
    public ItemWriter zoneFaceDataSta2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_zone_day_face_recognition_sta (person_mantime, person_count, custom_mantime, custom_count, male_mantime, male_count, female_mantime, female_count, staff_mantime, staff_count, countdate, mall_id, account_id, floor_id,zone_id, male_stage, female_stage,counttime,new_custom_count,new_male_count,new_female_count,new_male_stage,new_female_stage,regular_custom_count,regular_male_count,regular_female_count,regular_male_stage,regular_female_stage) VALUES (:personMantime,:personCount,:customMantime,:customCount,:maleMantime,:maleCount,:femaleMantime,:femaleCount,:staffMantime,:staffCount,:countDate,:mallId,:accountId,:floorId,:zoneId,:maleStage,:femaleStage,:countTime,:newCustomCount,:newMaleCount,:newFemaleCount,:newMaleStage,:newFemaleStage,:regularCustomCount,:regularMaleCount,:regularFemaleCount,:regularMaleStage,:regularFemaleStage);";
        String updateSql = "UPDATE d_zone_day_face_recognition_sta SET person_mantime=:personMantime, person_count=:personCount, custom_mantime=:customMantime, custom_count=:customCount, male_mantime=:maleMantime, male_count=:maleCount, female_mantime=:femaleMantime, female_count=:femaleCount, staff_mantime=:staffMantime, staff_count=:staffCount, countdate=:countDate, mall_id=:mallId, account_id=:accountId, floor_id=:floorId,zone_id=:zoneId, male_stage=:maleStage, female_stage=:femaleStage ,counttime=:countTime ,new_custom_count=:newCustomCount,new_male_count=:newMaleCount,new_female_count=:newFemaleCount,new_male_stage=:newMaleStage,new_female_stage=:newFemaleStage,regular_custom_count=:regularCustomCount,regular_male_count=:regularMaleCount,regular_female_count=:regularFemaleCount,regular_male_stage=:regularMaleStage,regular_female_stage=:regularFemaleStage WHERE  mall_id=:mallId and zone_id=:zoneId and countdate = :countDate;";
        5 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"zoneHourFaceDataSta2DBWriter"})
    public ItemWriter zoneHourFaceDataSta2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_zone_hour_face_recognition_sta (person_mantime, person_count, custom_mantime, custom_count, male_mantime, male_count, female_mantime, female_count, staff_mantime, staff_count, countdate, mall_id, account_id, floor_id,zone_id, male_stage, female_stage,counttime,hour,new_custom_count,new_male_count,new_female_count,new_male_stage,new_female_stage,regular_custom_count,regular_male_count,regular_female_count,regular_male_stage,regular_female_stage) VALUES (:personMantime,:personCount,:customMantime,:customCount,:maleMantime,:maleCount,:femaleMantime,:femaleCount,:staffMantime,:staffCount,:countDate,:mallId,:accountId,:floorId,:zoneId,:maleStage,:femaleStage,:countTime,:hour,:newCustomCount,:newMaleCount,:newFemaleCount,:newMaleStage,:newFemaleStage,:regularCustomCount,:regularMaleCount,:regularFemaleCount,:regularMaleStage,:regularFemaleStage);";
        String updateSql = "UPDATE d_zone_hour_face_recognition_sta SET person_mantime=:personMantime, person_count=:personCount, custom_mantime=:customMantime, custom_count=:customCount, male_mantime=:maleMantime, male_count=:maleCount, female_mantime=:femaleMantime, female_count=:femaleCount, staff_mantime=:staffMantime, staff_count=:staffCount, countdate=:countDate, mall_id=:mallId, account_id=:accountId, floor_id=:floorId,zone_id=:zoneId, male_stage=:maleStage, female_stage=:femaleStage ,counttime=:countTime ,hour=:hour ,new_custom_count=:newCustomCount,new_male_count=:newMaleCount,new_female_count=:newFemaleCount,new_male_stage=:newMaleStage,new_female_stage=:newFemaleStage,regular_custom_count=:regularCustomCount,regular_male_count=:regularMaleCount,regular_female_count=:regularFemaleCount,regular_male_stage=:regularMaleStage,regular_female_stage=:regularFemaleStage WHERE  mall_id=:mallId and zone_id=:zoneId and countdate=:countDate and counttime = :countTime;";
        6 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"gateFaceDataSta2DBWriter"})
    public ItemWriter gateFaceDataSta2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_gate_day_face_recognition_sta (person_mantime, person_count, custom_mantime, custom_count, male_mantime, male_count, female_mantime, female_count, staff_mantime, staff_count, countdate, mall_id, account_id, gate_id, male_stage, female_stage,counttime,new_custom_count,new_male_count,new_female_count,new_male_stage,new_female_stage,regular_custom_count,regular_male_count,regular_female_count,regular_male_stage,regular_female_stage) VALUES (:personMantime,:personCount,:customMantime,:customCount,:maleMantime,:maleCount,:femaleMantime,:femaleCount,:staffMantime,:staffCount,:countDate,:mallId,:accountId,:gateId,:maleStage,:femaleStage,:countTime,:newCustomCount,:newMaleCount,:newFemaleCount,:newMaleStage,:newFemaleStage,:regularCustomCount,:regularMaleCount,:regularFemaleCount,:regularMaleStage,:regularFemaleStage);";
        String updateSql = "UPDATE d_gate_day_face_recognition_sta SET person_mantime=:personMantime, person_count=:personCount, custom_mantime=:customMantime, custom_count=:customCount, male_mantime=:maleMantime, male_count=:maleCount, female_mantime=:femaleMantime, female_count=:femaleCount, staff_mantime=:staffMantime, staff_count=:staffCount, countdate=:countDate, mall_id=:mallId, account_id=:accountId, gate_id=:gateId, male_stage=:maleStage, female_stage=:femaleStage ,counttime=:countTime ,new_custom_count=:newCustomCount,new_male_count=:newMaleCount,new_female_count=:newFemaleCount,new_male_stage=:newMaleStage,new_female_stage=:newFemaleStage,regular_custom_count=:regularCustomCount,regular_male_count=:regularMaleCount,regular_female_count=:regularFemaleCount,regular_male_stage=:regularMaleStage,regular_female_stage=:regularFemaleStage WHERE  mall_id=:mallId and gate_id=:gateId and countdate = :countDate;";
        7 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"gateHourFaceDataSta2DBWriter"})
    public ItemWriter gateHourFaceDataSta2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_gate_hour_face_recognition_sta (person_mantime, person_count, custom_mantime, custom_count, male_mantime, male_count, female_mantime, female_count, staff_mantime, staff_count, countdate, mall_id, account_id, gate_id, male_stage, female_stage,counttime,hour,new_custom_count,new_male_count,new_female_count,new_male_stage,new_female_stage,regular_custom_count,regular_male_count,regular_female_count,regular_male_stage,regular_female_stage) VALUES (:personMantime,:personCount,:customMantime,:customCount,:maleMantime,:maleCount,:femaleMantime,:femaleCount,:staffMantime,:staffCount,:countDate,:mallId,:accountId,:gateId,:maleStage,:femaleStage,:countTime,:hour,:newCustomCount,:newMaleCount,:newFemaleCount,:newMaleStage,:newFemaleStage,:regularCustomCount,:regularMaleCount,:regularFemaleCount,:regularMaleStage,:regularFemaleStage);";
        String updateSql = "UPDATE d_gate_hour_face_recognition_sta SET person_mantime=:personMantime, person_count=:personCount, custom_mantime=:customMantime, custom_count=:customCount, male_mantime=:maleMantime, male_count=:maleCount, female_mantime=:femaleMantime, female_count=:femaleCount, staff_mantime=:staffMantime, staff_count=:staffCount, countdate=:countDate, mall_id=:mallId, account_id=:accountId, gate_id=:gateId, male_stage=:maleStage, female_stage=:femaleStage ,counttime=:countTime ,hour=:hour ,new_custom_count=:newCustomCount,new_male_count=:newMaleCount,new_female_count=:newFemaleCount,new_male_stage=:newMaleStage,new_female_stage=:newFemaleStage,regular_custom_count=:regularCustomCount,regular_male_count=:regularMaleCount,regular_female_count=:regularFemaleCount,regular_male_stage=:regularMaleStage,regular_female_stage=:regularFemaleStage WHERE  mall_id=:mallId and gate_id=:gateId and countdate=:countDate and counttime = :countTime;";
        8 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    static /* synthetic */ FaceDataStaKeyService access$000(FaceSta2DBJobConfiguration x0) {
        return x0.keyService;
    }

    static /* synthetic */ Logger access$100(FaceSta2DBJobConfiguration x0) {
        return x0.logger;
    }
}

