/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.configuration;

import com.viontech.keliu.batch.configuration.FaceDataJobConfiguration;
import com.viontech.keliu.batch.item.processor.BaiduCalibrateInfoProcessor;
import com.viontech.keliu.batch.item.processor.CompositeItemStreamProcessor;
import com.viontech.keliu.batch.item.processor.CustomRecognitionProcessor;
import com.viontech.keliu.batch.item.processor.DataFilterProcessor;
import com.viontech.keliu.batch.item.processor.FaceDataIsRepeatProcessor;
import com.viontech.keliu.batch.item.processor.FaceDataOrgProcessor;
import com.viontech.keliu.batch.item.processor.FaceDataValidProcessor;
import com.viontech.keliu.batch.item.processor.FeatureExtractProcessor;
import com.viontech.keliu.batch.item.processor.PersonRecognitionProcessor;
import com.viontech.keliu.batch.item.processor.PicIsReadyProcessor;
import com.viontech.keliu.batch.item.processor.ReidDataProcessor;
import com.viontech.keliu.batch.item.processor.RepeatedFaceProcessor;
import com.viontech.keliu.batch.item.processor.StaffRecognitionProcessor;
import com.viontech.keliu.batch.listener.ExecutionContextClearListener;
import com.viontech.keliu.batch.listener.JobRestartListener;
import com.viontech.keliu.batch.listener.StepLoggerListener;
import com.viontech.keliu.batch.listener.WorkQueueClearChunkListener;
import com.viontech.keliu.content.FaceDataContent;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.JdbcBatchItemWriter;
import org.springframework.batch.item.support.CompositeItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class FaceDataJobConfiguration {
    private final Logger logger = LoggerFactory.getLogger(FaceDataJobConfiguration.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Value(value="${spring.batch.job.chunkSize:1}")
    private int chunkSize;

    @Bean(name={"faceDataProcessJob"})
    public Job faceDataProcessJob(JobRepository jobRepository, Step faceDataStep, JobRestartListener jobRestartListener) {
        return ((SimpleJobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("faceDataProcessJob").incrementer((JobParametersIncrementer)new RunIdIncrementer())).repository(jobRepository)).start(faceDataStep).listener((JobExecutionListener)jobRestartListener)).build();
    }

    @Bean(name={"faceDataStep"})
    public Step faceDataStep(ItemReader<FaceDataContent> rawFaceDataRedisPopReader, ItemProcessor<FaceDataContent, FaceDataContent> faceDataCompositeProcessor, ItemWriter<FaceDataContent> faceDataCompositeWriter) {
        RepeatTemplate stepOperations = new RepeatTemplate();
        stepOperations.setCompletionPolicy((CompletionPolicy)new /* Unavailable Anonymous Inner Class!! */);
        return ((StepBuilder)((StepBuilder)((StepBuilder)this.stepBuilderFactory.get("faceDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).listener((StepExecutionListener)new StepLoggerListener())).listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(this.chunkSize).listener((ItemReadListener)new /* Unavailable Anonymous Inner Class!! */).listener((ItemWriteListener)new /* Unavailable Anonymous Inner Class!! */).reader(rawFaceDataRedisPopReader).processor(faceDataCompositeProcessor).writer(faceDataCompositeWriter).stepOperations((RepeatOperations)stepOperations).listener((ChunkListener)new WorkQueueClearChunkListener()).build();
    }

    @Bean(value={"faceDataCompositeProcessor"})
    public ItemProcessor<FaceDataContent, FaceDataContent> faceDataCompositeProcessor(PicIsReadyProcessor picIsReadyProcessor, FaceDataValidProcessor faceDataValidProcessor, StaffRecognitionProcessor staffRecognitionProcessor, FaceDataOrgProcessor faceDataOrgProcessor, FaceDataIsRepeatProcessor faceDataIsRepeatProcessor, FeatureExtractProcessor featureExtractProcessor, CustomRecognitionProcessor customRecognitionProcessor, RepeatedFaceProcessor repeatedFaceProcessor, DataFilterProcessor dataFilterProcessor, BaiduCalibrateInfoProcessor baiduCalibrateInfoProcessor, ReidDataProcessor reidDataProcessor, PersonRecognitionProcessor personRecognitionProcessor) {
        ArrayList<Object> delegates = new ArrayList<Object>();
        delegates.add(faceDataValidProcessor);
        delegates.add(picIsReadyProcessor);
        delegates.add(faceDataOrgProcessor);
        delegates.add(baiduCalibrateInfoProcessor);
        delegates.add(featureExtractProcessor);
        delegates.add(staffRecognitionProcessor);
        delegates.add(personRecognitionProcessor);
        delegates.add(customRecognitionProcessor);
        delegates.add(faceDataIsRepeatProcessor);
        CompositeItemStreamProcessor faceDataCompositeProcessor = new CompositeItemStreamProcessor();
        faceDataCompositeProcessor.setDelegates(delegates);
        return faceDataCompositeProcessor;
    }

    @Bean(name={"faceDataCompositeWriter"})
    public ItemWriter<FaceDataContent> faceDataCompositeWriter(ItemWriter faceDataSta2RedisWriter, ItemWriter faceHourDataSta2RedisWriter, ItemWriter faceData2DBWriter, JdbcTemplate jdbcTemplate, ItemWriter residenceDataWriter, ItemWriter faceData2CountData2RedisWriter) {
        CompositeItemWriter compositeItemWriter = new CompositeItemWriter();
        ArrayList<ItemWriter> delegates = new ArrayList<ItemWriter>();
        delegates.add(faceDataSta2RedisWriter);
        delegates.add(faceHourDataSta2RedisWriter);
        delegates.add(faceData2DBWriter);
        delegates.add(faceData2CountData2RedisWriter);
        compositeItemWriter.setDelegates(delegates);
        return compositeItemWriter;
    }

    @Bean(value={"rawFaceDataRedisPopReader"})
    public ItemReader rawFaceDataRedisPopReader(RedisTemplate redisTemplate, @Value(value="#{'${spring.cloud.client.ip-address}'+':'+'${server.port}'}") String ipPort) {
        4 concurrencyReader = new /* Unavailable Anonymous Inner Class!! */;
        return concurrencyReader;
    }

    @Bean(name={"faceData2DBWriter"})
    public ItemWriter faceData2DBWriter(DataSource dataSource) {
        JdbcBatchItemWriter writer = new JdbcBatchItemWriter();
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        String sql = "INSERT INTO d_face_recognition (device_id, channel_id, gate_id, person_unid,person_type, device_serialnum, channel_serialnum, face_pic, body_pic, mood, age, gender, direction, counttime, countdate, mall_id, account_id,status,track_info,track_time,happy_conf,unid,history_arrival_count,face_score,face_type,face_pic_num,body_pic_num ,face_feature_type ,body_feature_type ) VALUES (:deviceId, :channelId, :gateId, :personId, :personType ,:vasId, :channelSerialnum, :facePic, :bodyPic, :mood, :age, :gender, :direction, :countDate, :countDate, :mallId, :accountId,:status,:trackInfo,:trackTime,:happyConf,:unid,:historyArrivalCount,:face_score,:face_type,:facePicNum,:bodyPicNum,:faceFeatureType,:bodyFeatureType);";
        writer.setSql(sql);
        writer.setDataSource(dataSource);
        return writer;
    }

    @Bean(name={"residenceDataWriter"})
    public ItemWriter residenceDataWriter(DataSource dataSource) {
        String insertSql = "INSERT INTO d_residence (mall_id,account_id,arr_face_pic,arr_body_pic,arrival_unid,age,gender,arrival_time,countdate,counttime,arr_mood,leave_face_pic,leave_body_pic,leave_unid,leave_time,residence_time,leave_mood,real)VALUES(:mallId,:accountId,:facePic,:bodyPic,:arrivalUnid,:age,:gender,:arrivalTime,:countDate,:countDate,:happyConf,:facePic,:bodyPic,:personId,:leaveTime,:residenceTime,:happyConf,0)";
        String updateSql = "UPDATE d_residence SET leave_face_pic=:facePic,leave_body_pic=:bodyPic,leave_unid=:personId,leave_time=:countDate,residence_time=:residenceTime,leave_mood=:happyConf,real=1 WHERE arrival_unid=:arrivalUnid";
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Logger access$000(FaceDataJobConfiguration x0) {
        return x0.logger;
    }
}

