/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.configuration;

import com.viontech.keliu.batch.listener.ExecutionContextClearListener;
import com.viontech.keliu.batch.tasklet.DeviceStatusUpdateTasklet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DeviceStatusUpdateJobConfiguration {
    private final Logger logger = LoggerFactory.getLogger(DeviceStatusUpdateJobConfiguration.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    private int chunkSize = 1;

    @Bean(name={"deviceStatusUpdateJob"})
    public Job countDataRedis2DBJob(JobRepository jobRepository, Step deviceStatusUpdateStep) {
        return ((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("deviceStatusUpdateJob").incrementer((JobParametersIncrementer)new RunIdIncrementer())).repository(jobRepository)).start(deviceStatusUpdateStep).build();
    }

    @Bean(name={"deviceStatusUpdateStep"})
    public Step countDataKey2RedisStep(DeviceStatusUpdateTasklet deviceStatusUpdateTasklet) {
        return ((StepBuilder)this.stepBuilderFactory.get("deviceStatusUpdateStep").listener((StepExecutionListener)new ExecutionContextClearListener())).tasklet((Tasklet)deviceStatusUpdateTasklet).build();
    }
}

