/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.configuration;

import com.viontech.keliu.queue.QueueProcessStepBuilder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
public class CountDataQueueProcessJobConfiguration
implements ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(CountDataQueueProcessJobConfiguration.class);
    private ApplicationContext applicationContext;
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private JobLauncher jobLauncher;
    private QueueProcessStepBuilder<String, String> queueProcessStepBuilder = new QueueProcessStepBuilder();

    @Bean(name={"countDataQueueProcessJob"})
    public Job countDataQueueProcessJob(JobRepository jobRepository, Step countDataQueueProcessStep) {
        return ((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("countDataQueueProcessJob").incrementer((JobParametersIncrementer)new RunIdIncrementer())).repository(jobRepository)).start(countDataQueueProcessStep).build();
    }

    @Bean(value={"countDataQueueProcessStep"})
    public Step countDataQueueProcessStep(RedisTemplate redisTemplate) {
        return this.queueProcessStepBuilder.queueName("countData").stepBuilderFactory(this.stepBuilderFactory).stepName("countDataQueueProcessStep").redisTemplate(redisTemplate).processor(item -> {
            String result = item + "processor";
            return result;
        }).writer(items -> {
            List list = (List)items;
        }).build();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

