/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.configuration;

import com.viontech.keliu.batch.configuration.CountDataJobConfiguration;
import com.viontech.keliu.batch.item.processor.FloorCountDataProcessor;
import com.viontech.keliu.batch.item.processor.GateCountDataProcessor;
import com.viontech.keliu.batch.item.processor.MallCountDataProcessor;
import com.viontech.keliu.batch.item.processor.ZoneCountDataProcessor;
import com.viontech.keliu.batch.item.reader.RedisHashDataReader;
import com.viontech.keliu.batch.listener.ExecutionContextClearListener;
import com.viontech.keliu.batch.tasklet.CountDataKey2RedisTasklet;
import com.viontech.keliu.service.CountDataKeyService;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class CountDataJobConfiguration {
    private final Logger logger = LoggerFactory.getLogger(CountDataJobConfiguration.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Resource
    private CountDataKeyService countDataKeyService;
    @Value(value="${spring.batch.job.chunkSize:1}")
    private int chunkSize = 1;
    @Value(value="${vion.time-offset.mall-day:0}")
    private int mallDayTimeOffset;

    @Bean(name={"countDataRedis2DBJob"})
    public Job countDataRedis2DBJob(JobRepository jobRepository, Step countDataKey2RedisStep, Step gateMinuteCountDataStep, Step gateHourCountDataStep, Step gateDayCountDataStep, Step zoneMinuteCountDataStep, Step zoneHourCountDataStep, Step zoneDayCountDataStep, Step floorMinuteCountDataStep, Step floorHourCountDataStep, Step floorDayCountDataStep, Step mallMinuteCountDataStep, Step mallHourCountDataStep, Step mallDayCountDataStep) {
        return ((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("countDataRedis2DBJob").incrementer((JobParametersIncrementer)new RunIdIncrementer())).repository(jobRepository)).start(gateMinuteCountDataStep).next(gateHourCountDataStep).next(gateDayCountDataStep).next(zoneMinuteCountDataStep).next(zoneHourCountDataStep).next(zoneDayCountDataStep).next(floorMinuteCountDataStep).next(floorHourCountDataStep).next(floorDayCountDataStep).next(mallMinuteCountDataStep).next(mallHourCountDataStep).next(mallDayCountDataStep).build();
    }

    @Bean(name={"countDataKey2RedisStep"})
    public Step countDataKey2RedisStep(CountDataKey2RedisTasklet countDataKey2RedisTasklet) {
        return this.stepBuilderFactory.get("countDataKey2RedisStep").tasklet((Tasklet)countDataKey2RedisTasklet).build();
    }

    @Bean(name={"gateMinuteCountDataStep"})
    public Step gateMinuteCountDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter gateMinuteCountData2DBWriter) {
        GateCountDataProcessor gateCountDataProcessor = new GateCountDataProcessor(this.mallDayTimeOffset);
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "countData:minute:gate:*");
        return ((StepBuilder)this.stepBuilderFactory.get("gateMinuteCountDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(this.chunkSize).reader((ItemReader)dataReader).processor((ItemProcessor)gateCountDataProcessor).writer(gateMinuteCountData2DBWriter).build();
    }

    @Bean(name={"gateHourCountDataStep"})
    public Step gateHourCountDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter gateHourCountData2DBWriter) {
        GateCountDataProcessor gateCountDataProcessor = new GateCountDataProcessor(this.mallDayTimeOffset);
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "countData:hour:gate:*");
        return ((StepBuilder)this.stepBuilderFactory.get("gateHourCountDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(this.chunkSize).reader((ItemReader)dataReader).processor((ItemProcessor)gateCountDataProcessor).writer(gateHourCountData2DBWriter).build();
    }

    @Bean(name={"gateDayCountDataStep"})
    public Step gateDayCountDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter gateDayCountData2DBWriter) {
        GateCountDataProcessor gateCountDataProcessor = new GateCountDataProcessor(0);
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "countData:day:gate:*");
        return ((StepBuilder)this.stepBuilderFactory.get("gateDayCountDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(this.chunkSize).reader((ItemReader)dataReader).processor((ItemProcessor)gateCountDataProcessor).writer(gateDayCountData2DBWriter).build();
    }

    @Bean(name={"zoneMinuteCountDataStep"})
    public Step zoneMinuteCountDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter zoneMinuteCountData2DBWriter) {
        ZoneCountDataProcessor zoneCountDataProcessor = new ZoneCountDataProcessor(this.mallDayTimeOffset);
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "countData:minute:zone:*");
        return ((StepBuilder)this.stepBuilderFactory.get("zoneMinuteCountDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(this.chunkSize).reader((ItemReader)dataReader).processor((ItemProcessor)zoneCountDataProcessor).writer(zoneMinuteCountData2DBWriter).build();
    }

    @Bean(name={"zoneHourCountDataStep"})
    public Step zoneHourCountDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter zoneHourCountData2DBWriter) {
        ZoneCountDataProcessor zoneCountDataProcessor = new ZoneCountDataProcessor(this.mallDayTimeOffset);
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "countData:hour:zone:*");
        return ((StepBuilder)this.stepBuilderFactory.get("zoneHourCountDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(this.chunkSize).reader((ItemReader)dataReader).processor((ItemProcessor)zoneCountDataProcessor).writer(zoneHourCountData2DBWriter).build();
    }

    @Bean(name={"zoneDayCountDataStep"})
    public Step zoneDayCountDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter zoneDayCountData2DBWriter) {
        ZoneCountDataProcessor zoneCountDataProcessor = new ZoneCountDataProcessor(0);
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "countData:day:zone:*");
        return ((StepBuilder)this.stepBuilderFactory.get("zoneDayCountDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(this.chunkSize).reader((ItemReader)dataReader).processor((ItemProcessor)zoneCountDataProcessor).writer(zoneDayCountData2DBWriter).build();
    }

    @Bean(name={"floorMinuteCountDataStep"})
    public Step floorMinuteCountDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter floorMinuteCountData2DBWriter) {
        FloorCountDataProcessor floorCountDataProcessor = new FloorCountDataProcessor(this.mallDayTimeOffset);
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "countData:minute:floor:*");
        return ((StepBuilder)this.stepBuilderFactory.get("floorMinuteCountDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(this.chunkSize).reader((ItemReader)dataReader).processor((ItemProcessor)floorCountDataProcessor).writer(floorMinuteCountData2DBWriter).build();
    }

    @Bean(name={"floorHourCountDataStep"})
    public Step floorHourCountDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter floorHourCountData2DBWriter) {
        FloorCountDataProcessor floorCountDataProcessor = new FloorCountDataProcessor(this.mallDayTimeOffset);
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "countData:hour:floor:*");
        return ((StepBuilder)this.stepBuilderFactory.get("floorHourCountDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(10).reader((ItemReader)dataReader).processor((ItemProcessor)floorCountDataProcessor).writer(floorHourCountData2DBWriter).build();
    }

    @Bean(name={"floorDayCountDataStep"})
    public Step floorDayCountDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter floorDayCountData2DBWriter) {
        FloorCountDataProcessor floorCountDataProcessor = new FloorCountDataProcessor(0);
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "countData:day:floor:*");
        return ((StepBuilder)this.stepBuilderFactory.get("floorDayCountDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(10).reader((ItemReader)dataReader).processor((ItemProcessor)floorCountDataProcessor).writer(floorDayCountData2DBWriter).build();
    }

    @Bean(name={"mallMinuteCountDataStep"})
    public Step mallMinuteCountDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter mallMinuteCountData2DBWriter) {
        MallCountDataProcessor mallCountDataProcessor = new MallCountDataProcessor(this.mallDayTimeOffset);
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "countData:minute:mall:*");
        return ((StepBuilder)this.stepBuilderFactory.get("mallMinuteCountDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(10).reader((ItemReader)dataReader).processor((ItemProcessor)mallCountDataProcessor).writer(mallMinuteCountData2DBWriter).build();
    }

    @Bean(name={"mallHourCountDataStep"})
    public Step mallHourCountDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter mallHourCountData2DBWriter) {
        MallCountDataProcessor mallCountDataProcessor = new MallCountDataProcessor(this.mallDayTimeOffset);
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "countData:hour:mall:*");
        return ((StepBuilder)this.stepBuilderFactory.get("mallHourCountDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(this.chunkSize).reader((ItemReader)dataReader).processor((ItemProcessor)mallCountDataProcessor).writer(mallHourCountData2DBWriter).build();
    }

    @Bean(name={"mallDayCountDataStep"})
    public Step mallDayCountDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, RedisTemplate redisTemplate, ItemWriter mallDayCountData2DBWriter) {
        MallCountDataProcessor mallCountDataProcessor = new MallCountDataProcessor(0);
        RedisHashDataReader dataReader = new RedisHashDataReader(redisTemplate, "countData:day:mall:*");
        return ((StepBuilder)this.stepBuilderFactory.get("mallDayCountDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(this.chunkSize).reader((ItemReader)dataReader).processor((ItemProcessor)mallCountDataProcessor).writer(mallDayCountData2DBWriter).build();
    }

    @Bean(name={"gateMinuteCountData2DBWriter"})
    public ItemWriter gateMinuteCountData2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_gate_minute_count_data(mall_id, account_id, gate_id, innum, outnum, countdate, counttime, hour) VALUES (:mallId, :accountId, :gateId, :innum, :outnum, :countDate, :countTime, :hour);";
        String updateSql = "UPDATE d_gate_minute_count_data  SET innum=:innum,outnum=:outnum where mall_id=:mallId and countdate=:countDate and gate_id=:gateId and countTime = :countTime;";
        1 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"gateHourCountData2DBWriter"})
    public ItemWriter gateHourCountData2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_gate_hour_count_data(mall_id, account_id, gate_id, innum, outnum, countdate, counttime, hour) VALUES (:mallId, :accountId, :gateId, :innum, :outnum, :countDate, :countTime, :hour);";
        String updateSql = "UPDATE d_gate_hour_count_data  SET innum=:innum,outnum=:outnum where mall_id=:mallId and countdate=:countDate and gate_id=:gateId and countTime = :countTime;";
        2 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"gateDayCountData2DBWriter"})
    public ItemWriter gateDayCountData2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_gate_day_count_data(mall_id, account_id, gate_id, innum, outnum, countdate, counttime) VALUES (:mallId, :accountId, :gateId, :innum, :outnum, :countDate, :countTime);";
        String updateSql = "UPDATE d_gate_day_count_data  SET innum=:innum,outnum=:outnum where mall_id=:mallId and countdate=:countDate and gate_id=:gateId and countTime = :countTime;";
        3 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"zoneMinuteCountData2DBWriter"})
    public ItemWriter zoneMinuteCountData2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_zone_minute_count_data(mall_id, account_id, floor_id, zone_id, innum, outnum, outside_innum, outside_outnum, countdate, counttime, hour) VALUES (:mallId, :accountId, :floorId, :zoneId, :innum, :outnum, :outsideInnum, :outsideOutnum, :countDate, :countTime, :hour);";
        String updateSql = "UPDATE d_zone_minute_count_data  SET innum=:innum,outnum=:outnum,outside_innum=:outsideInnum,outside_outnum=:outsideOutnum where mall_id=:mallId and countdate=:countDate and zone_id=:zoneId and countTime = :countTime;";
        4 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"zoneHourCountData2DBWriter"})
    public ItemWriter zoneHourCountData2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_zone_hour_count_data(mall_id, account_id, floor_id, zone_id, innum, outnum, outside_innum, outside_outnum, countdate, counttime, hour) VALUES (:mallId, :accountId, :floorId, :zoneId, :innum, :outnum, :outsideInnum, :outsideOutnum, :countDate, :countTime, :hour);";
        String updateSql = "UPDATE d_zone_hour_count_data  SET innum=:innum,outnum=:outnum,outside_innum=:outsideInnum,outside_outnum=:outsideOutnum  where mall_id=:mallId and countdate=:countDate and zone_id=:zoneId and countTime = :countTime;";
        5 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"zoneDayCountData2DBWriter"})
    public ItemWriter zoneDayCountData2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_zone_day_count_data(mall_id, account_id, floor_id, zone_id, innum, outnum, outside_innum, outside_outnum, countdate, counttime) VALUES (:mallId, :accountId, :floorId, :zoneId, :innum, :outnum, :outsideInnum, :outsideOutnum, :countDate, :countTime);";
        String updateSql = "UPDATE d_zone_day_count_data  SET innum=:innum,outnum=:outnum,outside_innum=:outsideInnum,outside_outnum=:outsideOutnum  where mall_id=:mallId and countdate=:countDate and zone_id=:zoneId and countTime = :countTime;";
        6 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"floorMinuteCountData2DBWriter"})
    public ItemWriter floorMinuteCountData2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_floor_minute_count_data(mall_id, account_id, floor_id, innum, outnum, countdate, counttime, hour) VALUES (:mallId, :accountId, :floorId, :innum, :outnum, :countDate, :countTime, :hour);";
        String updateSql = "UPDATE d_floor_minute_count_data  SET innum=:innum,outnum=:outnum where mall_id=:mallId and countdate=:countDate and floor_id=:floorId and countTime = :countTime;";
        7 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"floorHourCountData2DBWriter"})
    public ItemWriter floorHourCountData2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_floor_hour_count_data(mall_id, account_id, floor_id, innum, outnum, countdate, counttime, hour) VALUES (:mallId, :accountId, :floorId, :innum, :outnum, :countDate, :countTime, :hour);";
        String updateSql = "UPDATE d_floor_hour_count_data  SET innum=:innum,outnum=:outnum where mall_id=:mallId and countdate=:countDate and floor_id=:floorId and countTime = :countTime;";
        8 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"floorDayCountData2DBWriter"})
    public ItemWriter floorDayCountData2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_floor_day_count_data(mall_id, account_id, floor_id, innum, outnum, countdate, counttime) VALUES (:mallId, :accountId, :floorId, :innum, :outnum, :countDate, :countTime);";
        String updateSql = "UPDATE d_floor_day_count_data  SET innum=:innum,outnum=:outnum where mall_id=:mallId and countdate=:countDate and floor_id=:floorId and countTime = :countTime;";
        9 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"mallMinuteCountData2DBWriter"})
    public ItemWriter mallMinuteCountData2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_mall_minute_count_data(mall_id, account_id, innum, outnum,outside_innum, outside_outnum, countdate, counttime,hour) VALUES (:mallId, :accountId, :innum, :outnum, :outsideInnum, :outsideOutnum, :countDate, :countTime, :hour);";
        String updateSql = "UPDATE d_mall_minute_count_data  SET innum=:innum,outnum=:outnum,outside_innum=:outsideInnum,outside_outnum=:outsideOutnum where mall_id=:mallId and countdate=:countDate and countTime = :countTime;";
        10 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"mallHourCountData2DBWriter"})
    public ItemWriter mallHourCountData2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_mall_hour_count_data(mall_id, account_id, innum, outnum,outside_innum, outside_outnum, countdate, counttime, hour) VALUES (:mallId, :accountId, :innum, :outnum, :outsideInnum, :outsideOutnum,  :countDate, :countTime, :hour);";
        String updateSql = "UPDATE d_mall_hour_count_data  SET innum=:innum,outnum=:outnum,outside_innum=:outsideInnum,outside_outnum=:outsideOutnum where mall_id=:mallId and countdate=:countDate and countTime = :countTime;";
        11 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    @Bean(name={"mallDayCountData2DBWriter"})
    public ItemWriter mallDayCountData2DBWriter(DataSource dataSource, RedisTemplate redisTemplate) {
        String insertSql = "INSERT INTO d_mall_day_count_data(mall_id, account_id, innum, outnum,outside_innum, outside_outnum, countdate, counttime) VALUES (:mallId, :accountId, :innum, :outnum, :outsideInnum, :outsideOutnum, :countDate, :countTime);";
        String updateSql = "UPDATE d_mall_day_count_data  SET innum=:innum,outnum=:outnum,outside_innum=:outsideInnum,outside_outnum=:outsideOutnum where mall_id=:mallId and countdate=:countDate and countTime = :countTime;";
        12 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }

    static /* synthetic */ CountDataKeyService access$000(CountDataJobConfiguration x0) {
        return x0.countDataKeyService;
    }

    static /* synthetic */ Logger access$100(CountDataJobConfiguration x0) {
        return x0.logger;
    }
}

