/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import java.text.MessageFormat;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class BatchJobService {
    @Autowired
    private JobExplorer jobExplorer;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    public final String SQL_DEL_JOB_INSTANCE = "DELETE FROM batch_job_instance where job_instance_id not in(select job_instance_id from batch_job_execution) and job_name= ?;";
    public final String SQL_DEL_JOB_EXECUTION = "DELETE FROM batch_job_execution WHERE job_execution_id IN ( SELECT je.job_execution_id FROM batch_job_execution je\n  LEFT JOIN batch_job_instance ji ON ji.job_instance_id = je.job_instance_id WHERE job_name = ? {0} ORDER BY je.job_instance_id DESC OFFSET ? );";
    public final String SQL_DEL_JOB_EXECUTION_CONTEXT = "DELETE FROM batch_job_execution_context WHERE job_execution_id IN ( SELECT je.job_execution_id FROM batch_job_execution je\n  LEFT JOIN batch_job_instance ji ON ji.job_instance_id = je.job_instance_id WHERE job_name = ? {0} ORDER BY je.job_instance_id DESC OFFSET ?);";
    public final String SQL_DEL_JOB_EXECUTION_PARAMS = "DELETE FROM batch_job_execution_params WHERE job_execution_id IN ( SELECT je.job_execution_id FROM batch_job_execution je\n  LEFT JOIN batch_job_instance ji ON ji.job_instance_id = je.job_instance_id WHERE job_name = ? {0} ORDER BY je.job_instance_id DESC OFFSET ?);";
    public final String SQL_DEL_STEP_EXECUTION = "DELETE FROM batch_step_execution WHERE job_execution_id IN ( SELECT je.job_execution_id FROM batch_job_execution je\n  LEFT JOIN batch_job_instance ji ON ji.job_instance_id = je.job_instance_id WHERE job_name = ? {0} ORDER BY je.job_instance_id DESC OFFSET ?);";
    public final String SQL_DEL_STEP_EXECUTION_CONTEXT = "DELETE FROM batch_step_execution_context WHERE step_execution_id IN ( SELECT step_execution_id FROM batch_step_execution\n  WHERE job_execution_id IN (SELECT je.job_execution_id FROM batch_job_execution je LEFT JOIN batch_job_instance ji \n  ON ji.job_instance_id = je.job_instance_id WHERE job_name = ? {0} ORDER BY je.job_instance_id DESC OFFSET ?)); ";

    public void clearBatch() {
        for (String jobName : this.jobExplorer.getJobNames()) {
            this.delJobByName(jobName, true, 100);
            this.delJobByName(jobName, false, 1000);
        }
    }

    private boolean delJobByName(String jobName, boolean isComplete, int skipNum) {
        boolean result = true;
        result &= this.delStep(jobName, isComplete, skipNum);
        result &= this.delJobExecutionParams(jobName, isComplete, skipNum);
        result &= this.delJobExecutionContext(jobName, isComplete, skipNum);
        result &= this.delJobExecution(jobName, isComplete, skipNum);
        return result &= this.delJobInstance(jobName);
    }

    private boolean delStep(String jobName, boolean isComplete, int skipJobNum) {
        boolean result = true;
        result &= this.delStepExecutionContext(jobName, isComplete, skipJobNum);
        return result &= this.delStepExecution(jobName, isComplete, skipJobNum);
    }

    private boolean delJobInstance(String jobName) {
        return this.sqlResult(this.jdbcTemplate.update("DELETE FROM batch_job_instance where job_instance_id not in(select job_instance_id from batch_job_execution) and job_name= ?;", new Object[]{jobName}));
    }

    private boolean delJobExecution(String jobName, boolean isComplete, int skipJobNum) {
        return this.sqlResult(this.jdbcTemplate.update(this.sqlFormat("DELETE FROM batch_job_execution WHERE job_execution_id IN ( SELECT je.job_execution_id FROM batch_job_execution je\n  LEFT JOIN batch_job_instance ji ON ji.job_instance_id = je.job_instance_id WHERE job_name = ? {0} ORDER BY je.job_instance_id DESC OFFSET ? );", isComplete), new Object[]{jobName, skipJobNum}));
    }

    private boolean delJobExecutionContext(String jobName, boolean isComplete, int skipJobNum) {
        return this.sqlResult(this.jdbcTemplate.update(this.sqlFormat("DELETE FROM batch_job_execution_context WHERE job_execution_id IN ( SELECT je.job_execution_id FROM batch_job_execution je\n  LEFT JOIN batch_job_instance ji ON ji.job_instance_id = je.job_instance_id WHERE job_name = ? {0} ORDER BY je.job_instance_id DESC OFFSET ?);", isComplete), new Object[]{jobName, skipJobNum}));
    }

    private boolean delJobExecutionParams(String jobName, boolean isComplete, int skipJobNum) {
        return this.sqlResult(this.jdbcTemplate.update(this.sqlFormat("DELETE FROM batch_job_execution_params WHERE job_execution_id IN ( SELECT je.job_execution_id FROM batch_job_execution je\n  LEFT JOIN batch_job_instance ji ON ji.job_instance_id = je.job_instance_id WHERE job_name = ? {0} ORDER BY je.job_instance_id DESC OFFSET ?);", isComplete), new Object[]{jobName, skipJobNum}));
    }

    private boolean delStepExecution(String jobName, boolean isComplete, int skipJobNum) {
        return this.sqlResult(this.jdbcTemplate.update(this.sqlFormat("DELETE FROM batch_step_execution WHERE job_execution_id IN ( SELECT je.job_execution_id FROM batch_job_execution je\n  LEFT JOIN batch_job_instance ji ON ji.job_instance_id = je.job_instance_id WHERE job_name = ? {0} ORDER BY je.job_instance_id DESC OFFSET ?);", isComplete), new Object[]{jobName, skipJobNum}));
    }

    private boolean delStepExecutionContext(String jobName, boolean isComplete, int skipJobNum) {
        return this.sqlResult(this.jdbcTemplate.update(this.sqlFormat("DELETE FROM batch_step_execution_context WHERE step_execution_id IN ( SELECT step_execution_id FROM batch_step_execution\n  WHERE job_execution_id IN (SELECT je.job_execution_id FROM batch_job_execution je LEFT JOIN batch_job_instance ji \n  ON ji.job_instance_id = je.job_instance_id WHERE job_name = ? {0} ORDER BY je.job_instance_id DESC OFFSET ?)); ", isComplete), new Object[]{jobName, skipJobNum}));
    }

    private boolean sqlResult(int result) {
        return result > 0;
    }

    private String sqlFormat(String sql, boolean isComplete) {
        if (isComplete) {
            return MessageFormat.format(sql, " and je.status='COMPLETED'");
        }
        return MessageFormat.format(sql, " and je.status!='COMPLETED'");
    }
}

