/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.runner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.exception.ParameterExceptin;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.vo.websocket.Result;
import com.viontech.keliu.websocket.AlgApiClient;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.sql.DataSource;
import javax.websocket.DeploymentException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class ResidenceRunner
implements CommandLineRunner {
    private Logger logger = LoggerFactory.getLogger(ResidenceRunner.class);
    private final String SELECT_SQL = "SELECT arrival_time FROM d_residence WHERE arrival_unid = ? LIMIT 1";
    @Value(value="${ws.url:}")
    private String url;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired
    DataSource dataSource;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired(required=false)
    private AlgApiClient algApiClientComparison;

    public void run(String ... args) throws Exception {
        if (this.url == null || this.url.trim().isEmpty()) {
            return;
        }
    }

    public void scheduledDelKey() {
        try {
            this.run(new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getAbnormalPerson() throws DeploymentException, IOException, ParameterExceptin {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        if (this.algApiClientComparison == null) {
            this.algApiClientComparison = new AlgApiClient(this.url);
        }
        CompletableFuture responseFuture = this.algApiClientComparison.queryPersonPool(1, "0", new HashMap(0));
        JSONObject response = null;
        try {
            response = (JSONObject)responseFuture.get(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        if (response == null) {
            System.out.println("\u7279\u5f81\u6c60\u67e5\u8be2\u5931\u8d25");
            return;
        }
        System.out.println(response.toString());
        Result result = (Result)this.objectMapper.readValue(response.toString(), Result.class);
        Integer errCode = result.getErrCode();
        if (errCode != null && errCode == 4) {
            return;
        }
        JSONArray pools = response.getJSONArray("poolIds");
        HashMap<String, Integer> poolIdMap = new HashMap<String, Integer>(2);
        for (Object pool : pools) {
            String poolId = ((JSONObject)pool).getString("poolId");
            Integer count = ((JSONObject)pool).getInt("personCount");
            if (!poolId.contains(this.getPoolIdPrefix())) continue;
            poolIdMap.put(poolId, count);
        }
        for (Map.Entry entry : poolIdMap.entrySet()) {
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                try {
                    responseFuture = this.algApiClientComparison.getAbnormalPerson(DateUtil.format((String)DateUtil.FORMAT_LONG, (Date)new Date()), (String)entry.getKey(), new ArrayList(), new HashMap());
                    response = (JSONObject)responseFuture.get(120L, TimeUnit.SECONDS);
                    System.out.println(response.toString());
                    if (response.getInt("success") != 1) continue;
                    String personUnid = response.getString("personId");
                    String dateStr = response.getString("outTime");
                    if (dateStr == null || "".equals(dateStr) || "".equals(personUnid)) continue;
                    Date leaveTime = DateUtil.parse((String)DateUtil.FORMAT_LONG, (String)dateStr);
                    int update = 0;
                    Date arrivalTime = null;
                    try {
                        arrivalTime = (Date)template.queryForObject("SELECT arrival_time FROM d_residence WHERE arrival_unid = ? LIMIT 1", new Object[]{personUnid}, Date.class);
                    }
                    catch (EmptyResultDataAccessException e) {
                        this.logger.error("\u67e5\u65e0\u6b64\u8bb0\u5f55");
                    }
                    if (arrivalTime != null) {
                        int residenceTime = (int)((leaveTime.getTime() - arrivalTime.getTime()) / 1000L);
                        update = template.update("UPDATE d_residence SET residence_time=? WHERE arrival_unid=?", new Object[]{residenceTime, personUnid});
                    }
                    if (update != 0 || arrivalTime == null) {
                        Person person = new Person();
                        person.setPersonId(personUnid);
                        ArrayList<Person> persons = new ArrayList<Person>(1);
                        persons.add(person);
                        this.algApiClientComparison.delPersonPool(0, (String)entry.getKey(), persons, new HashMap());
                        continue;
                    }
                    this.logger.info("\u5f02\u5e38\u6ede\u7559\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e,arrival_unid:{}", (Object)personUnid);
                    continue;
                }
                catch (ParameterExceptin | IOException | ParseException | DeploymentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getPoolIdPrefix() {
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        Date date = c.getTime();
        String format = DateUtil.format((String)DateUtil.FORMAT_SHORT, (Date)date);
        return this.applicationName + "_residencePool_" + format;
    }

    public static void main(String[] args) throws DeploymentException, IOException, ParameterExceptin {
        ResidenceRunner runner = new ResidenceRunner();
        runner.url = "ws://192.168.9.113:10080";
        runner.applicationName = "vionDevelop";
        runner.getAbnormalPerson();
    }
}

