/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.runner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.model.License;
import com.viontech.keliu.util.SerialNumberUtil;
import com.viontech.keliu.util.SymmetricEncoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

@Component
@Order(value=1)
public class LicenseCheckRunner
implements CommandLineRunner {
    private static Logger logger = LoggerFactory.getLogger(LicenseCheckRunner.class);
    @Autowired
    private ObjectMapper objectMapper;

    private String getJarRootPath() throws FileNotFoundException {
        String path = ResourceUtils.getURL((String)"classpath:").getPath();
        try {
            path = URLDecoder.decode(path, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        File rootFile = new File(path);
        if (!rootFile.exists()) {
            rootFile = new File("");
        }
        return rootFile.getAbsolutePath();
    }

    public void run(String ... args) throws Exception {
        try {
            logger.info("\u9879\u76ee\u6839\u76ee\u5f55{}", (Object)this.getJarRootPath());
            String jarFile = this.getJarRootPath();
            File file = new File(jarFile, "license.lic");
            logger.info("License\u6587\u4ef6\u5730\u5740:{}", (Object)file.getAbsolutePath());
            byte[] bytes = Files.readAllBytes(Paths.get(file.toURI()));
            logger.info("License\u6587\u4ef6\u5185\u5bb9:{}", (Object)new String(bytes));
            String license = SymmetricEncoder.AESDecode((String)"lHnhwGAXvCCtGPmN", (String)new String(bytes));
            logger.info("\u89e3\u5bc6\u540eLicense\u5185\u5bb9\uff1a{}", (Object)license);
            Map localSnMap = SerialNumberUtil.getAllSn();
            HashMap licenseMap = (HashMap)this.objectMapper.readValue(license, HashMap.class);
            boolean checkResult = this.check((Map)licenseMap, localSnMap);
            if (checkResult) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                License.date = sdf.parse((String)licenseMap.get("licenseDate"));
                this.checkDate();
            }
        }
        catch (Exception e) {
            logger.error("\u6388\u6743\u6821\u9a8c\u51fa\u73b0\u95ee\u9898", (Throwable)e);
        }
    }

    public void checkDate() {
        if (License.date.after(new Date())) {
            License.dateCheck = true;
        } else {
            logger.error("\u6388\u6743\u5df2\u7ecf\u8fc7\u671f");
        }
    }

    private boolean check(Map<String, String> licenseMap, Map<String, String> localSnMap) {
        boolean result = true;
        if (this.snEquls(licenseMap.get("cpuId"), localSnMap.get("cpuId"))) {
            License.cpuIdCheck = true;
        } else {
            logger.error("\u8be5\u673a\u5668CPU-ID\u4e0e\u6388\u6743\u6587\u4ef6\u4e0d\u7b26\u5408");
            result = false;
        }
        if (this.snEquls(licenseMap.get("diskId"), localSnMap.get("diskId"))) {
            License.diskIdCheck = true;
        } else {
            logger.error("\u8be5\u673a\u5668\u786c\u76d8\u5e8f\u5217\u53f7\u4e0e\u6388\u6743\u6587\u4ef6\u4e0d\u7b26\u5408");
            result = false;
        }
        if (this.snEquls(licenseMap.get("mainboardId"), localSnMap.get("mainboardId"))) {
            License.mainborrdCheck = true;
        } else {
            logger.error("\u8be5\u673a\u5668\u4e3b\u677f\u5e8f\u5217\u53f7\u4e0e\u6388\u6743\u6587\u4ef6\u4e0d\u7b26\u5408");
            result = false;
        }
        return result;
    }

    private boolean snEquls(String sn1, String sn2) {
        return sn1 != null && sn2 != null && sn1.equals(sn2);
    }

    public static void main(String[] args) {
        String s = "peww8Cf+dupsivOHGgBGmXjLJvi47J1tatjjz1xY3M6F1oqlWoguEt6TiUG+pZi+yBT4HTkTaM9cf0SQ7KuIalzqgEKyrRiiaUK4X10X4ywnxIDCFzN51SfjXU0u4IPeoU1sQX7CdeKSrqH76AxKR8KSN0kGqFQslfOo9FvdNe1NjNku2rG7sxrVhFMGWTQc";
        System.out.println(SymmetricEncoder.AESDecode((String)"lHnhwGAXvCCtGPmN", (String)s));
    }
}

