/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.runner;

import com.viontech.keliu.dao.MallDao;
import com.viontech.keliu.model.ConfigParam;
import com.viontech.keliu.model.Mall;
import com.viontech.keliu.service.ConfigParamService;
import com.viontech.keliu.util.ConfigUtil;
import com.viontech.keliu.websocket.AlgApiClient;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class FeatureLibraryClearRunner
implements CommandLineRunner {
    private Logger logger = LoggerFactory.getLogger(FeatureLibraryClearRunner.class);
    @Value(value="${ws.url:}")
    private String url;
    @Value(value="${spring.application.name:}")
    private String applicationName;
    private static final int DELETE_SUCCESS_CODE = 1;
    @Resource
    private ConfigParamService configParamService;
    @Resource
    private MallDao mallDao;
    @Autowired(required=false)
    private AlgApiClient algApiClientComparison;

    public void run(String ... args) throws Exception {
        try {
            if (this.url.isEmpty()) {
                return;
            }
            Map configParamMap = this.configParamService.selectAll();
            HashMap<String, Long> mallMatchDayMap = new HashMap<String, Long>();
            List malls = this.mallDao.selectAll();
            for (Mall mall : malls) {
                String unid = mall.getUnid();
                Long mallId = mall.getId();
                ConfigParam configParam = ConfigUtil.getConfigParam((Long)mallId, (Map)configParamMap);
                String newOrRegular = configParam.getNewOrRegular();
                mallMatchDayMap.put(unid, Long.parseLong(newOrRegular));
            }
            this.logger.info("\u5386\u53f2\u7279\u5f81\u5e93\u6e05\u7406\u4efb\u52a1\u5f00\u59cb");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            Date now = calendar.getTime();
            CompletableFuture responseFuture = this.algApiClientComparison.queryPersonPool(1, "customPool,1970-01-01,1", new HashMap());
            JSONObject response = (JSONObject)responseFuture.get(120L, TimeUnit.SECONDS);
            if (response.isNull("poolIds")) {
                return;
            }
            JSONArray poolIds = response.getJSONArray("poolIds");
            for (int i = 0; i < poolIds.length(); ++i) {
                try {
                    String[] ss;
                    JSONObject obj = poolIds.getJSONObject(i);
                    String poolId = obj.getString("poolId");
                    if (!poolId.contains("customPool") || !poolId.contains(this.applicationName) || (ss = poolId.split("_")).length <= 1) continue;
                    String dateString = ss[ss.length - 2];
                    if (dateString == null || "".equals(dateString) || !dateString.matches("\\d{4}-\\d{2}-\\d{2}")) continue;
                    Date date = sdf.parse(dateString);
                    String unid = ss[ss.length - 1];
                    Long matchDay = (Long)mallMatchDayMap.get(unid);
                    if (matchDay == null || matchDay == 0L) {
                        matchDay = 30L;
                    }
                    if ((now.getTime() - date.getTime()) / 86400000L < matchDay + 1L) continue;
                    this.logger.info("\u5f00\u59cb\u5220\u9664\u7279\u5f81\u6c60{}", (Object)poolId);
                    System.out.println("\u5f00\u59cb\u5220\u9664\u7279\u5f81\u5e93:" + poolId + "\u5339\u914d\u5929\u6570\u4e3a:" + matchDay);
                    responseFuture = this.algApiClientComparison.delPersonPool(1, poolId, new ArrayList(), new HashMap());
                    response = (JSONObject)responseFuture.get(120L, TimeUnit.SECONDS);
                    if (response.getInt("success") == 1) {
                        System.out.println("\u7279\u5f81\u5e93\u6e05\u9664\u4efb\u52a1-\u6e05\u9664\u7279\u5f81\u5e93:" + poolId);
                        this.logger.info("\u5220\u9664{}\u7279\u5f81\u6c60\u6210\u529f", (Object)poolId);
                        continue;
                    }
                    this.logger.info("\u5220\u9664{}\u7279\u5f81\u6c60\u5931\u8d25", (Object)poolId);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Scheduled(cron="01 0 06 * * ?")
    public void featureLibraryClearTiming() {
        try {
            this.run(new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

