/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.queue;

import com.viontech.keliu.queue.QueueHandler;
import com.viontech.keliu.queue.RedisWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.util.Assert;

public class QueueHandler<I, O> {
    private RedisTemplate redisTemplate;
    private String queueName;
    private String processingQueueName;
    private String failedQueueName;
    private int awaitInMillis = 0;
    public static final int DEFAULT_AWAIT_IN_MILLIS = 100;
    public ReentrantLock lock = new ReentrantLock();
    public Condition notEmpty = this.lock.newCondition();
    public Function<I, O> processor;
    public Consumer<List> writer;
    public RedisWriter<O> redisWriter;

    public final I read() {
        Assert.hasLength((String)this.queueName, (String)"queueName is not can null or Empty");
        while (true) {
            String id = null;
            try {
                id = (String)this.redisTemplate.opsForList().rightPopAndLeftPush((Object)this.queueName, (Object)this.processingQueueName);
            }
            catch (Exception e) {
                continue;
            }
            if (id != null) {
                this.awaitInMillis = 100;
                return (I)id;
            }
            this.lock.lock();
            try {
                if (this.awaitInMillis < 1000) {
                    this.awaitInMillis += this.awaitInMillis;
                }
                this.notEmpty.await(this.awaitInMillis, TimeUnit.MILLISECONDS);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
    }

    public final ItemEntry process(I item) throws Exception {
        ItemEntry result = new ItemEntry(this);
        result.setSource(item);
        result.setTarget(this.doProcess(item));
        return result;
    }

    public final void write(List<? extends ItemEntry> items) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        for (ItemEntry itemEntry : items) {
            list.add(itemEntry.getTarget());
        }
        this.doWrite(list);
    }

    protected O doProcess(I item) throws Exception {
        return (O)this.processor.apply(item);
    }

    protected void doWrite(List<O> items) throws Exception {
        this.writer.accept(items);
    }

    public void fail(List<ItemEntry> items) {
        this.redisTemplate.execute((SessionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void success(List<ItemEntry> items) {
        this.redisTemplate.execute((SessionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Function<I, O> getProcessor() {
        return this.processor;
    }

    public void setProcessor(Function<I, O> processor) {
        this.processor = processor;
    }

    public Consumer<List> getWriter() {
        return this.writer;
    }

    public void setWriter(Consumer<List> writer) {
        this.writer = writer;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        String ip = "unknown";
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            ip = localHost.getHostAddress().toString();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.queueName = queueName.trim();
        this.processingQueueName = queueName.trim() + "_processing_queue_" + ip;
        this.failedQueueName = queueName.trim() + "_failed_queue";
    }

    public RedisWriter<O> getRedisWriter() {
        return this.redisWriter;
    }

    public void setRedisWriter(RedisWriter<O> redisWriter) {
        this.redisWriter = redisWriter;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String getProcessingQueueName() {
        return this.processingQueueName;
    }

    public void setProcessingQueueName(String processingQueueName) {
        this.processingQueueName = processingQueueName;
    }

    public String getFailedQueueName() {
        return this.failedQueueName;
    }

    public void setFailedQueueName(String failedQueueName) {
        this.failedQueueName = failedQueueName;
    }

    public int getAwaitInMillis() {
        return this.awaitInMillis;
    }

    public void setAwaitInMillis(int awaitInMillis) {
        this.awaitInMillis = awaitInMillis;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public void setLock(ReentrantLock lock) {
        this.lock = lock;
    }

    public Condition getNotEmpty() {
        return this.notEmpty;
    }

    public void setNotEmpty(Condition notEmpty) {
        this.notEmpty = notEmpty;
    }

    static /* synthetic */ String access$000(QueueHandler x0) {
        return x0.failedQueueName;
    }

    static /* synthetic */ String access$100(QueueHandler x0) {
        return x0.processingQueueName;
    }
}

