/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.jobhandler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.dao.ChannelDao;
import com.viontech.keliu.dao.FaceRecognitionDao;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.model.TrackInfo;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.util.DateUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TodayTrackProcessJob {
    private Logger logger = LoggerFactory.getLogger(TodayTrackProcessJob.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Resource
    private Storage simpleStringStorage;
    @Resource
    private FaceRecognitionDao faceRecognitionDao;
    @Resource
    private ChannelDao channelDao;

    @Scheduled(cron="05 05 05 * * ?")
    public void todayTrackProcesstiming() {
        Date yesterday = DateUtil.getYesterday((Date)new Date());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String dateStr = sdf.format(yesterday);
        this.logger.warn("\u8f68\u8ff9\u6587\u4ef6\u6c47\u603b\u5f00\u59cb,\u65e5\u671f:{}", (Object)dateStr);
        List channels = this.channelDao.select4TrackGroup();
        this.logger.warn("track\u6587\u4ef6\u6c47\u603b\u4efb\u52a1\u542f\u52a8\uff1a\u5904\u7406\u901a\u9053\u603b\u6570{}", (Object)channels.size());
        for (Channel channel : channels) {
            Long channelId = channel.getId();
            String channelSerialnum = channel.getSerialnum();
            List faceRecognitions = this.faceRecognitionDao.select4TrackGroup(yesterday, channelId);
            if (faceRecognitions == null || faceRecognitions.size() <= 0) {
                this.logger.warn("\u5f53\u524d\u5904\u7406\u7684\u901a\u9053\u4e3a\uff1a{},\u5904\u7406\u65e5\u671f\u4e3a\uff1a{}\uff0c\u6ca1\u6709\u6293\u62cd\u8bb0\u5f55\uff0c\u8df3\u8fc7\u6b64\u901a\u9053\u3002", (Object)channelSerialnum, (Object)dateStr);
            } else {
                this.logger.warn("\u5f53\u524d\u5904\u7406\u7684\u901a\u9053\u4e3a\uff1a{},\u5904\u7406\u65e5\u671f\u4e3a\uff1a{}\uff0c\u4eba\u8138\u6293\u62cd\u8bb0\u5f55\u4e3a\uff1a{}", new Object[]{channelSerialnum, dateStr, faceRecognitions.size()});
            }
            ArrayList<TrackInfo> trackInfos = new ArrayList<TrackInfo>();
            int size = faceRecognitions.size();
            int index = 1;
            for (FaceRecognition faceRecognition : faceRecognitions) {
                String trackPath = faceRecognition.getTrackPath();
                String trackName = faceRecognition.getTrackInfo();
                Object trackObj = this.simpleStringStorage.getItem(trackPath + trackName);
                if (trackObj == null) {
                    this.logger.warn("{}\u7684\u8f68\u8ff9\u6587\u4ef6\u4fe1\u606f\u65e0\u6cd5\u83b7\u53d6\u5230", (Object)trackName);
                    continue;
                }
                this.logger.debug("\u901a\u9053:{}\u4f30\u8ba1\u6c47\u603b,\u603b\u6761\u6570:{},\u5f53\u524d\u5904\u7406\u6761\u6570:{}", new Object[]{channelSerialnum, size, index++});
                try {
                    TrackInfo trackInfo2 = (TrackInfo)this.objectMapper.readValue(trackObj.toString(), TrackInfo.class);
                    trackInfos.add(trackInfo2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (trackInfos.size() <= 0) continue;
            try {
                trackInfos.forEach(trackInfo -> {
                    trackInfo.setFileName(null);
                    trackInfo.setId(null);
                    if (trackInfo.getTrack() != null) {
                        trackInfo.getTrack().forEach(track -> {
                            track.setW(null);
                            track.setFx(null);
                            track.setFy(null);
                        });
                    }
                });
                String trackJson = this.objectMapper.writeValueAsString(trackInfos);
                String trackKey = "trackgroup/" + dateStr + "/" + channelSerialnum + ".track";
                this.simpleStringStorage.setItem(trackKey, (Object)trackJson);
                this.logger.warn("\u65e5\u671f:{},\u901a\u9053:{},\u8f68\u8ff9\u6587\u4ef6\u5b58\u50a8\u5b8c\u6210\uff0c\u6c47\u603b\u6570\u91cf\u4e3a:{}", new Object[]{dateStr, channelSerialnum, trackInfos.size()});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.logger.warn("\u8f68\u8ff9\u6587\u4ef6\u6c47\u603b\u7ed3\u675f,\u65e5\u671f:{}", (Object)dateStr);
    }
}

