/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.jobhandler;

import com.viontech.keliu.dao.FaceRecognitionDao;
import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.util.DateUtil;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class NewRegularCustomProcessJob {
    @Autowired
    JobRepository jobRepository;
    private Logger logger = LoggerFactory.getLogger(NewRegularCustomProcessJob.class);
    @Autowired
    Job newRegularCustomJob;
    @Autowired
    private FaceRecognitionDao faceRecognitionDao;

    @Scheduled(cron="40 0/1 * * * ?")
    public void faceRecognitionRecordtiming() throws Exception {
        Date date = DateUtil.addDays((Date)new Date(), (int)-2);
        this.logger.info("\u65b0\u8001\u987e\u5ba2\u8bc6\u522b\u542f\u52a8,\u5f00\u59cb\u65f6\u95f4\u4e3a:{}", (Object)DateUtil.format((String)DateUtil.FORMAT_SHORT, (Date)date));
        InetAddress localHost = InetAddress.getLocalHost();
        String hostAddress = localHost.getHostAddress();
        int hashcode = hostAddress.hashCode();
        Boolean bl = this.faceRecognitionDao.updateRowsByHashCode(date, hashcode);
        if (!bl.booleanValue()) {
            this.logger.error("\u65b0\u8001\u987e\u5ba2\u5904\u7406-\u6ca1\u6709\u66f4\u65b0hashcode\u7684\u6761\u76ee\u6570\uff0c\u8df3\u8fc7\u672c\u6b21\u5904\u7406");
            return;
        }
        List faceRecognitions = this.faceRecognitionDao.selectIdsByHashCode(date, hashcode);
        if (faceRecognitions == null || faceRecognitions.size() < 1) {
            this.logger.info("\u5f85\u5904\u7406\u6570\u636e\u6761\u76ee\u4e3a0,\u65b0\u8001\u987e\u5ba2\u8bc6\u522b\u7ed3\u675f");
            return;
        }
        FaceRecognition faceRecognitionMin = (FaceRecognition)faceRecognitions.get(0);
        FaceRecognition faceRecognitionMax = (FaceRecognition)faceRecognitions.get(faceRecognitions.size() - 1);
        Long maxId = faceRecognitionMax.getId();
        Long minId = faceRecognitionMin.getId();
        if (minId < 0L) {
            minId = 0L;
        }
        this.logger.info("\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u8303\u56f4 {}-{}", (Object)minId, (Object)maxId);
        if (maxId == null || minId == null) {
            return;
        }
        SimpleAsyncTaskExecutor simpleAsyncTaskExecutor = new SimpleAsyncTaskExecutor();
        simpleAsyncTaskExecutor.setThreadNamePrefix("newRegularCustomExecutor-");
        SimpleJobLauncher sjl = new SimpleJobLauncher();
        sjl.setTaskExecutor((TaskExecutor)simpleAsyncTaskExecutor);
        sjl.setJobRepository(this.jobRepository);
        sjl.afterPropertiesSet();
        ArrayList<JobExecution> jobExecutions = new ArrayList<JobExecution>();
        long count = maxId - minId + 1L;
        System.out.println(count);
        long threadNum = count / 1000L + (long)(count % 1000L == 0L ? 0 : 1);
        if (threadNum > 10L) {
            threadNum = 10L;
        }
        this.logger.info("\u9700\u8981\u5f00\u542f {} \u4e2a\u7ebf\u7a0b\u8fdb\u884c\u5904\u7406", (Object)threadNum);
        long step = count / threadNum;
        int i = 0;
        while ((long)i < threadNum) {
            Long endNum = minId + step;
            if ((long)i == threadNum - 1L) {
                endNum = maxId + 1L;
            }
            Hashtable<String, Long> parameter = new Hashtable<String, Long>();
            parameter.put("time", System.currentTimeMillis() + (long)i);
            parameter.put("minId", minId);
            parameter.put("maxId", endNum);
            this.logger.info("\u5f00\u542f\u7b2c {} \u4e2a\u7ebf\u7a0b\uff0c\u5904\u7406\u8303\u56f4 {}-{}", new Object[]{i + 1, minId, endNum});
            JobParameters jobParameters = new JobParametersBuilder().addLong("minId", minId).addLong("maxId", endNum).addLong("time", Long.valueOf(System.currentTimeMillis() + (long)i)).toJobParameters();
            JobExecution run = sjl.run(this.newRegularCustomJob, jobParameters);
            this.logger.info("\u5f00\u542f\u5b8c\u6210 {} \u4e2a\u7ebf\u7a0b\uff0c\u5904\u7406\u8303\u56f4 {}-{}", new Object[]{i + 1, minId, endNum});
            jobExecutions.add(run);
            minId = endNum;
            ++i;
        }
        this.logger.info("\u65b0\u8001\u987e\u5ba2\u8bc6\u522b\u5b8c\u6210");
    }

    public static void main(String[] args) {
        long maxId = 225204L;
        long minId = 225204L;
        long count = maxId - minId + 1L;
        System.out.println(count);
        long threadNum = count / 1000L + (long)(count % 1000L == 0L ? 0 : 1);
        if (threadNum > 10L) {
            threadNum = 10L;
        }
        System.out.println(threadNum);
        long step = count / threadNum;
        int i = 0;
        while ((long)i < threadNum) {
            Long endNum = minId + step;
            if ((long)i == threadNum - 1L) {
                endNum = maxId + 1L;
            }
            System.out.println(i + "\t" + minId + "\t" + endNum);
            minId = endNum;
            ++i;
        }
    }
}

